/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMethod {
    private final RepositoryMetadata metadata;
    private final Method method;
    private final Parameters parameters;

    public QueryMethod(Method method, RepositoryMetadata metadata) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        for (Class<?> type : Parameters.TYPES) {
            if (org.springframework.data.repository.util.ClassUtils.getNumberOfOccurences(method, type) <= 1) continue;
            throw new IllegalStateException(String.format("Method must only one argument of type %s!", type.getSimpleName()));
        }
        if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType(method, Pageable.class)) {
            org.springframework.data.repository.util.ClassUtils.assertReturnType(method, Page.class, List.class);
            if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType(method, Sort.class)) {
                throw new IllegalStateException("Method must not have Pageable *and* Sort parameter. Use sorting capabilities on Pageble instead!");
            }
        }
        this.method = method;
        this.parameters = new Parameters(method);
        this.metadata = metadata;
    }

    public String getName() {
        return this.method.getName();
    }

    public EntityMetadata<?> getEntityInformation() {
        return new EntityMetadata(){

            public Class<?> getJavaType() {
                return QueryMethod.this.getDomainClass();
            }
        };
    }

    public String getNamedQueryName() {
        Class<?> domainClass = this.getDomainClass();
        return String.format("%s.%s", domainClass.getSimpleName(), this.method.getName());
    }

    protected Class<?> getDomainClass() {
        Class<?> repositoryDomainClass = this.metadata.getDomainClass();
        Class<?> methodDomainClass = org.springframework.data.repository.util.ClassUtils.getReturnedDomainClass(this.method);
        return repositoryDomainClass == null || repositoryDomainClass.isAssignableFrom(methodDomainClass) ? methodDomainClass : repositoryDomainClass;
    }

    protected boolean isCollectionQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(List.class, returnType);
    }

    protected boolean isPageQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(Page.class, returnType);
    }

    public Type getType() {
        if (this.isModifyingQuery()) {
            return Type.MODIFYING;
        }
        if (this.isPageQuery()) {
            return Type.PAGING;
        }
        if (this.isCollectionQuery()) {
            return Type.COLLECTION;
        }
        return Type.SINGLE_ENTITY;
    }

    protected boolean isModifyingQuery() {
        return false;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.method.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SINGLE_ENTITY,
        PAGING,
        COLLECTION,
        MODIFYING;

    }
}

