/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Property;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderBySource {
    private final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=[A-Z])";
    private final Pattern DIRECTION_SPLIT = Pattern.compile("(.+)(Asc|Desc)$");
    private final List<Sort.Order> orders = new ArrayList<Sort.Order>();

    public OrderBySource(String clause) {
        this(clause, null);
    }

    public OrderBySource(String clause, Class<?> domainClass) {
        for (String part : clause.split("(?<=Asc|Desc)(?=[A-Z])")) {
            Matcher matcher = this.DIRECTION_SPLIT.matcher(part);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format("Invalid order syntax for part %s!", part));
            }
            Sort.Direction direction = Sort.Direction.fromString(matcher.group(2));
            this.orders.add(this.createOrder(matcher.group(1), direction, domainClass));
        }
    }

    private Sort.Order createOrder(String propertySource, Sort.Direction direction, Class<?> domainClass) {
        if (null == domainClass) {
            return new Sort.Order(direction, StringUtils.uncapitalize((String)propertySource));
        }
        Property property = Property.from(propertySource, domainClass);
        return new Sort.Order(direction, property.toDotPath());
    }

    public Sort toSort() {
        return this.orders.isEmpty() ? null : new Sort(this.orders);
    }
}

