/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.repository.query.parser.Property;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Part {
    private final Property property;
    private final Type type;

    public Part(String part, Class<?> clazz) {
        this.type = Type.fromProperty(part, clazz);
        this.property = Property.from(this.type.extractProperty(part), clazz);
    }

    public boolean getParameterRequired() {
        return this.getNumberOfArguments() > 0;
    }

    public int getNumberOfArguments() {
        return this.type.getNumberOfArguments();
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Part that = (Part)obj;
        return this.property.equals(that.property) && this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = 37;
        result += 17 * this.property.hashCode();
        return result += 17 * this.type.hashCode();
    }

    public String toString() {
        return String.format("%s %s", new Object[]{this.property.getName(), this.type});
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BETWEEN(2, "Between"),
        IS_NOT_NULL(0, "IsNotNull", "NotNull"),
        IS_NULL(0, "IsNull", "Null"),
        LESS_THAN("LessThan"),
        GREATER_THAN("GreaterThan"),
        NOT_LIKE("NotLike"),
        LIKE("Like"),
        NOT_IN("NotIn"),
        IN("In"),
        NEAR("Near"),
        WITHIN("Within"),
        NEGATING_SIMPLE_PROPERTY("Not"),
        SIMPLE_PROPERTY(new String[0]);

        private static final List<Type> ALL;
        private List<String> keywords;
        private int numberOfArguments;

        private Type(int numberOfArguments, String ... keywords) {
            this.numberOfArguments = numberOfArguments;
            this.keywords = Arrays.asList(keywords);
        }

        private Type(String ... keywords) {
            this(1, keywords);
        }

        public static Type fromProperty(String rawProperty, Class<?> clazz) {
            for (Type type : ALL) {
                if (!type.supports(rawProperty, clazz)) continue;
                return type;
            }
            return SIMPLE_PROPERTY;
        }

        protected boolean supports(String property, Class<?> clazz) {
            if (this.keywords == null) {
                return true;
            }
            for (String keyword : this.keywords) {
                if (!property.endsWith(keyword)) continue;
                return true;
            }
            return false;
        }

        public int getNumberOfArguments() {
            return this.numberOfArguments;
        }

        public String extractProperty(String part) {
            String candidate = StringUtils.uncapitalize((String)part);
            for (String keyword : this.keywords) {
                if (!candidate.endsWith(keyword)) continue;
                return candidate.substring(0, candidate.indexOf(keyword));
            }
            return candidate;
        }

        static {
            ALL = Arrays.asList(IS_NOT_NULL, IS_NULL, BETWEEN, LESS_THAN, GREATER_THAN, NOT_LIKE, LIKE, NOT_IN, IN, NEAR, WITHIN, NEGATING_SIMPLE_PROPERTY, SIMPLE_PROPERTY);
        }
    }
}

