/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.OrderBySource;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartTree
implements Iterable<OrPart> {
    private static final String ORDER_BY = "OrderBy";
    private static final String KEYWORD_TEMPLATE = "(%s)(?=[A-Z])";
    private static final String DISTINCT = "Distinct";
    private static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get)(\\p{Upper}.*?)??By");
    private final boolean distinct;
    private final OrderBySource orderBySource;
    private final List<OrPart> nodes = new ArrayList<OrPart>();

    public PartTree(String source, Class<?> domainClass) {
        Assert.notNull((Object)source);
        Assert.notNull(domainClass);
        this.distinct = this.detectDistinct(source);
        String foo = this.strip(source);
        String[] parts = PartTree.split(foo, ORDER_BY);
        if (parts.length > 2) {
            throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
        }
        this.buildTree(parts[0], domainClass);
        this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1], domainClass) : null;
    }

    @Override
    public Iterator<OrPart> iterator() {
        return this.nodes.iterator();
    }

    private void buildTree(String source, Class<?> domainClass) {
        String[] split;
        for (String part : split = PartTree.split(source, "Or")) {
            this.nodes.add(new OrPart(part, domainClass));
        }
    }

    public Sort getSort() {
        return this.orderBySource == null ? null : this.orderBySource.toSort();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Iterable<Part> getParts() {
        ArrayList<Part> result = new ArrayList<Part>();
        for (OrPart orPart : this) {
            for (Part part : orPart) {
                result.add(part);
            }
        }
        return result;
    }

    private static String[] split(String text, String keyword) {
        String regex = String.format(KEYWORD_TEMPLATE, keyword);
        Pattern pattern = Pattern.compile(regex);
        return pattern.split(text);
    }

    private String strip(String methodName) {
        Matcher matcher = PREFIX_TEMPLATE.matcher(methodName);
        if (matcher.find()) {
            return methodName.substring(matcher.group().length());
        }
        return methodName;
    }

    private boolean detectDistinct(String source) {
        Matcher matcher = PREFIX_TEMPLATE.matcher(source);
        if (!matcher.find()) {
            return false;
        }
        String group = matcher.group(2);
        return group != null && group.contains(DISTINCT);
    }

    public String toString() {
        return String.format("%s %s", StringUtils.collectionToDelimitedString(this.nodes, (String)" or "), this.orderBySource.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrPart
    implements Iterable<Part> {
        private final List<Part> children = new ArrayList<Part>();

        OrPart(String source, Class<?> domainClass) {
            String[] split;
            for (String part : split = PartTree.split(source, "And")) {
                this.children.add(new Part(part, domainClass));
            }
        }

        public String toString() {
            return StringUtils.collectionToDelimitedString(this.children, (String)" and ");
        }

        @Override
        public Iterator<Part> iterator() {
            return this.children.iterator();
        }
    }
}

