/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property {
    private static final String DELIMITERS = "_\\.";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private static final String ERROR_TEMPLATE = "No property %s found for type %s";
    private final TypeInformation<?> owningType;
    private final String name;
    private final TypeInformation<?> type;
    private final boolean isCollection;
    private Property next;

    Property(String name, Class<?> owningType) {
        this(name, ClassTypeInformation.from(owningType));
    }

    Property(String name, TypeInformation<?> owningType) {
        Assert.hasText((String)name);
        Assert.notNull(owningType);
        String propertyName = StringUtils.uncapitalize((String)name);
        TypeInformation<?> type = owningType.getProperty(propertyName);
        if (type == null) {
            throw new IllegalArgumentException(String.format(ERROR_TEMPLATE, propertyName, owningType.getType()));
        }
        this.owningType = owningType;
        this.isCollection = type.isCollectionLike();
        this.type = type.getActualType();
        this.name = propertyName;
    }

    Property(String name, TypeInformation<?> owningType, String toTraverse) {
        this(name, owningType);
        if (StringUtils.hasText((String)toTraverse)) {
            this.next = Property.from(toTraverse, this.type);
        }
    }

    public TypeInformation<?> getOwningType() {
        return this.owningType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type.getType();
    }

    public Property next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getName() + "." + this.next().toDotPath();
        }
        return this.getName();
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Property that = (Property)obj;
        return this.name.equals(that.name) && this.type.equals(this.type);
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode();
    }

    public static Property from(String source, Class<?> type) {
        return Property.from(source, ClassTypeInformation.from(type));
    }

    private static Property from(String source, TypeInformation<?> type) {
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher = SPLITTER.matcher("_" + source);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        Property result = null;
        Property current = null;
        while (parts.hasNext()) {
            if (result == null) {
                current = result = Property.create((String)parts.next(), type);
                continue;
            }
            current = Property.create((String)parts.next(), current);
        }
        return result;
    }

    private static Property create(String source, Property base) {
        Property property;
        base.next = property = Property.create(source, base.type);
        return property;
    }

    private static Property create(String source, TypeInformation<?> type) {
        return Property.create(source, type, "");
    }

    private static Property create(String source, TypeInformation<?> type, String addTail) {
        IllegalArgumentException exception = null;
        try {
            return new Property(source, type, addTail);
        }
        catch (IllegalArgumentException e) {
            exception = e;
            Pattern pattern = Pattern.compile("[A-Z]?[a-z]*$");
            Matcher matcher = pattern.matcher(source);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source.substring(0, position);
                String tail = source.substring(position);
                return Property.create(head, type, tail + addTail);
            }
            throw exception;
        }
    }
}

