/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.transaction;

import java.util.IdentityHashMap;
import java.util.Map;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class NaiveDoubleTransactionManager
implements PlatformTransactionManager {
    Map<TransactionStatus, TransactionStatus> status = new IdentityHashMap<TransactionStatus, TransactionStatus>();
    private final PlatformTransactionManager a;
    private final PlatformTransactionManager b;

    public NaiveDoubleTransactionManager(PlatformTransactionManager a, PlatformTransactionManager b) {
        System.err.println("WARNING: Naive JTA/Neo4j Spring transaction manager--must implement properly");
        this.a = a;
        this.b = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(TransactionStatus ts) throws TransactionException {
        try {
            TransactionStatus tsb = this.copyTransactionStatus(this.status.get(ts));
            try {
                this.a.commit(ts);
            }
            catch (Throwable t) {
                System.err.println("Continuing to commit tx despite this:" + t);
            }
            try {
                this.b.commit(tsb);
            }
            catch (Throwable t) {
                System.err.println("Can't commit tx" + t);
                throw new TransactionException(t.getMessage(), t){};
            }
        }
        finally {
            this.status.remove(ts);
        }
    }

    private TransactionStatus copyTransactionStatus(TransactionStatus ts) {
        Object t = ts instanceof DefaultTransactionStatus ? ((DefaultTransactionStatus)ts).getTransaction() : null;
        return new DefaultTransactionStatus(t, ts.isNewTransaction(), false, false, false, null);
    }

    public TransactionStatus getTransaction(TransactionDefinition td) throws TransactionException {
        TransactionStatus atx = this.a.getTransaction(td);
        TransactionStatus btx = this.b.getTransaction(td);
        this.status.put(atx, btx);
        return atx;
    }

    public void rollback(TransactionStatus ts) throws TransactionException {
        TransactionStatus tsb = this.copyTransactionStatus(this.status.remove(ts));
        try {
            this.a.rollback(ts);
        }
        catch (Throwable t) {
            System.err.println("Continuing to rollback tx despite this:" + t);
        }
        try {
            this.b.rollback(tsb);
        }
        catch (Throwable t) {
            System.err.println("Can't rollback tx" + t);
            throw new TransactionException(t.getMessage(), t){};
        }
    }
}

