/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.springframework.data.util.GenericTypeResolver;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.util.TypeVariableTypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeInformation<S>
extends TypeDiscoverer<S> {
    private final Class<S> type;

    public static <S> TypeInformation<S> from(Class<S> type) {
        return new ClassTypeInformation<S>(type);
    }

    public ClassTypeInformation(Class<S> type) {
        this(type, GenericTypeResolver.getTypeVariableMap(type));
    }

    ClassTypeInformation(Class<S> type, Map<TypeVariable, Type> typeVariableMap) {
        super(type, typeVariableMap);
        this.type = type;
    }

    @Override
    public Class<S> getType() {
        return this.type;
    }

    @Override
    public TypeInformation<?> getComponentType() {
        if (this.type.isArray()) {
            return this.createInfo(ClassTypeInformation.resolveArrayType(this.type));
        }
        TypeVariable<Class<S>>[] typeParameters = this.type.getTypeParameters();
        return typeParameters.length > 0 ? new TypeVariableTypeInformation(typeParameters[0], this.getType(), this) : null;
    }

    private static Type resolveArrayType(Class<?> type) {
        Assert.isTrue((boolean)type.isArray());
        Class<?> componentType = type.getComponentType();
        return componentType.isArray() ? ClassTypeInformation.resolveArrayType(componentType) : componentType;
    }
}

