/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedTypeInformation<T>
extends TypeDiscoverer<T> {
    private final TypeDiscoverer<?> parent;

    public ParameterizedTypeInformation(Type type, TypeDiscoverer<?> parent) {
        super(type, null);
        Assert.notNull(parent);
        this.parent = parent;
    }

    @Override
    protected Map<TypeVariable, Type> getTypeVariableMap() {
        return this.parent != null ? this.parent.getTypeVariableMap() : super.getTypeVariableMap();
    }

    @Override
    protected TypeInformation<?> createInfo(Type fieldType) {
        if (this.parent.getType().equals(fieldType)) {
            return this.parent;
        }
        return super.createInfo(fieldType);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParameterizedTypeInformation that = (ParameterizedTypeInformation)obj;
        return this.parent == null ? that.parent == null : this.parent.equals(that.parent);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * ObjectUtils.nullSafeHashCode(this.parent);
    }
}

