/*
 * Copyright (c) 2011 by the original author(s).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mapping.model;

import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;



/**
 * Interface capturing mutator methods for {@link PersistentEntity}s.
 *
 * @author Oliver Gierke
 */
public interface MutablePersistentEntity<T, P extends PersistentProperty<P>>
		extends PersistentEntity<T, P> {

	/**
	 * Sets the id property for the entity.
	 *
	 * @param property
	 */
	void setIdProperty(P property);

	/**
	 * Adds a {@link PersistentProperty} to the entity.
	 *
	 * @param property
	 */
	void addPersistentProperty(P property);

	/**
	 * Adds an {@link Association} to the entity.
	 *
	 * @param association
	 */
	void addAssociation(Association<P> association);

	/**
	 * Callback method to trigger validation of the {@link PersistentEntity}. As
	 * {@link MutablePersistentEntity} is not immutable there might be some
	 * verification steps necessary after the object has reached is final state.
	 */
	void verify();
}