/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.authentication;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class UserCredentials {
    private final String username;
    private final String password;

    public UserCredentials() {
        this(null, null);
    }

    public UserCredentials(String username, String password) {
        this.username = StringUtils.hasText((String)username) ? username : null;
        this.password = StringUtils.hasText((String)password) ? password : null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        UserCredentials that = (UserCredentials)obj;
        return ObjectUtils.nullSafeEquals((Object)this.username, (Object)that.username) && ObjectUtils.nullSafeEquals((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.username);
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.password);
    }
}

