/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredConstructor<T> {
    private final Constructor<T> constructor;
    private final List<Parameter<?>> parameters;

    public PreferredConstructor(Constructor<T> constructor, Parameter<?> ... parameters) {
        Assert.notNull(constructor);
        Assert.notNull(parameters);
        ReflectionUtils.makeAccessible(constructor);
        this.constructor = constructor;
        this.parameters = Arrays.asList(parameters);
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public Iterable<Parameter<?>> getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isNoArgConstructor() {
        return this.parameters.isEmpty();
    }

    public boolean isExplicitlyAnnotated() {
        return this.constructor.isAnnotationPresent(PersistenceConstructor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter<T> {
        private final String name;
        private final TypeInformation<T> type;
        private final String key;

        public Parameter(String name, TypeInformation<T> type, Annotation[] annotations) {
            Assert.notNull(type);
            Assert.notNull((Object)annotations);
            this.name = name;
            this.type = type;
            this.key = this.getValue(annotations);
        }

        private String getValue(Annotation[] annotations) {
            for (Annotation anno : annotations) {
                if (anno.annotationType() != Value.class) continue;
                return ((Value)anno).value();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public TypeInformation<T> getType() {
            return this.type;
        }

        public Class<T> getRawType() {
            return this.type.getType();
        }

        public String getKey() {
            return this.key;
        }
    }
}

