/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentProperty<P extends PersistentProperty<P>>
implements PersistentProperty<P> {
    protected final String name;
    protected final PropertyDescriptor propertyDescriptor;
    protected final TypeInformation<?> information;
    protected final Class<?> rawType;
    protected final Field field;
    protected final Association<P> association;
    protected final PersistentEntity<?, P> owner;
    private final SimpleTypeHolder simpleTypeHolder;

    public AbstractPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        Assert.notNull((Object)field);
        Assert.notNull((Object)simpleTypeHolder);
        Assert.notNull(owner);
        this.name = field.getName();
        this.rawType = field.getType();
        this.information = owner.getTypeInformation().getProperty(this.name);
        this.propertyDescriptor = propertyDescriptor;
        this.field = field;
        this.association = this.isAssociation() ? this.createAssociation() : null;
        this.owner = owner;
        this.simpleTypeHolder = simpleTypeHolder;
    }

    protected abstract Association<P> createAssociation();

    @Override
    public PersistentEntity<?, P> getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.information.getType();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public TypeInformation<?> getTypeInformation() {
        return this.information;
    }

    @Override
    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        TypeInformation<?> nestedType;
        ArrayList result = new ArrayList();
        TypeInformation<?> type = this.getTypeInformation();
        if (this.isEntity()) {
            result.add(type);
        }
        if ((type.isCollectionLike() || this.isMap()) && (nestedType = this.getTypeInformationIfNotSimpleType(this.getTypeInformation().getActualType())) != null) {
            result.add(nestedType);
        }
        return result;
    }

    private TypeInformation<?> getTypeInformationIfNotSimpleType(TypeInformation<?> information) {
        return information == null || this.simpleTypeHolder.isSimpleType(information.getType()) ? null : information;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getSpelExpression() {
        return null;
    }

    @Override
    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    @Override
    public boolean shallBePersisted() {
        return !this.isTransient();
    }

    @Override
    public boolean isAssociation() {
        if (this.field.isAnnotationPresent(Reference.class)) {
            return true;
        }
        for (Annotation annotation : this.field.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Reference.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Association<P> getAssociation() {
        return this.association;
    }

    @Override
    public boolean isCollectionLike() {
        return this.information.isCollectionLike();
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    protected boolean isEntity() {
        boolean isComplexType = !this.simpleTypeHolder.isSimpleType(this.information.getActualType().getType());
        return isComplexType && !this.isTransient() && !this.isCollectionLike() && !this.isMap();
    }

    @Override
    public Class<?> getComponentType() {
        if (!this.isMap() && !this.isCollectionLike()) {
            return null;
        }
        TypeInformation<?> componentType = this.information.getComponentType();
        return componentType == null ? null : componentType.getType();
    }

    @Override
    public Class<?> getMapValueType() {
        return this.isMap() ? this.information.getMapValueType().getType() : null;
    }
}

