/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWrapper<E extends PersistentEntity<T, ?>, T> {
    private final T bean;
    private final ConversionService conversionService;

    public static <E extends PersistentEntity<T, ?>, T> BeanWrapper<E, T> create(T bean, ConversionService conversionService) {
        return new BeanWrapper<E, T>(bean, conversionService);
    }

    public static <E extends PersistentEntity<T, ?>, T> BeanWrapper<E, T> create(E entity, ParameterValueProvider provider, ConversionService conversionService) {
        return new BeanWrapper<E, T>(entity, provider, conversionService);
    }

    private BeanWrapper(T bean, ConversionService conversionService) {
        Assert.notNull(bean);
        this.bean = bean;
        this.conversionService = conversionService;
    }

    private BeanWrapper(E entity, ParameterValueProvider provider, ConversionService conversionService) {
        this.conversionService = conversionService;
        Object bean = null;
        PreferredConstructor constructor = entity.getPreferredConstructor();
        if (null == constructor) {
            try {
                Class clazz = entity.getType();
                if (clazz.isArray()) {
                    Class<Object> ctype = clazz;
                    int dims = 0;
                    while (ctype.isArray()) {
                        ctype = ctype.getComponentType();
                        ++dims;
                    }
                    bean = Array.newInstance(clazz, dims);
                } else {
                    bean = BeanUtils.instantiateClass(entity.getType());
                }
            }
            catch (BeanInstantiationException e) {
                throw new MappingInstantiationException(e.getMessage(), e);
            }
            this.bean = bean;
            return;
        }
        LinkedList params = new LinkedList();
        if (null != provider && constructor.hasParameters()) {
            for (PreferredConstructor.Parameter<?> parameter : constructor.getParameters()) {
                params.add(provider.getParameterValue(parameter));
            }
        }
        try {
            bean = BeanUtils.instantiateClass(constructor.getConstructor(), (Object[])params.toArray());
        }
        catch (BeanInstantiationException e) {
            throw new MappingInstantiationException(e.getMessage(), e);
        }
        this.bean = bean;
    }

    public void setProperty(PersistentProperty<?> property, Object value) throws IllegalAccessException, InvocationTargetException {
        this.setProperty(property, value, false);
    }

    public void setProperty(PersistentProperty<?> property, Object value, boolean fieldAccessOnly) {
        Method setter = property.getPropertyDescriptor() != null ? property.getPropertyDescriptor().getWriteMethod() : null;
        try {
            if (fieldAccessOnly || null == setter) {
                Object valueToSet = this.getPotentiallyConvertedValue(value, property.getType());
                ReflectionUtils.makeAccessible((Field)property.getField());
                ReflectionUtils.setField((Field)property.getField(), this.bean, valueToSet);
                return;
            }
            Class<?>[] paramTypes = setter.getParameterTypes();
            Object valueToSet = this.getPotentiallyConvertedValue(value, paramTypes[0]);
            ReflectionUtils.makeAccessible((Method)setter);
            ReflectionUtils.invokeMethod((Method)setter, this.bean, (Object[])new Object[]{valueToSet});
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    public Object getProperty(PersistentProperty<?> property) throws IllegalAccessException, InvocationTargetException {
        return this.getProperty(property, property.getType(), false);
    }

    public <S> S getProperty(PersistentProperty<?> property, Class<? extends S> type, boolean fieldAccessOnly) {
        try {
            Object obj;
            Method getter;
            Field field = property.getField();
            Method method = getter = null != property.getPropertyDescriptor() ? property.getPropertyDescriptor().getReadMethod() : null;
            if (fieldAccessOnly || null == getter) {
                ReflectionUtils.makeAccessible((Field)field);
                obj = ReflectionUtils.getField((Field)field, this.bean);
            } else {
                ReflectionUtils.makeAccessible((Method)getter);
                obj = ReflectionUtils.invokeMethod((Method)getter, this.bean);
            }
            return this.getPotentiallyConvertedValue(obj, type);
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    private <S> S getPotentiallyConvertedValue(Object source, Class<S> targetType) {
        boolean conversionNeeded;
        boolean conversionServiceAvailable = this.conversionService != null;
        boolean bl = conversionNeeded = source == null || !targetType.isAssignableFrom(source.getClass());
        if (conversionServiceAvailable && conversionNeeded) {
            return (S)this.conversionService.convert(source, targetType);
        }
        return (S)source;
    }

    public T getBean() {
        return this.bean;
    }
}

