/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpELAwareParameterValueProvider
implements ParameterValueProvider {
    private final SpelExpressionParser parser;
    private final EvaluationContext context;

    public SpELAwareParameterValueProvider(SpelExpressionParser parser, EvaluationContext context) {
        Assert.notNull((Object)parser);
        Assert.notNull((Object)context);
        this.parser = parser;
        this.context = context;
    }

    @Override
    public <T> T getParameterValue(PreferredConstructor.Parameter<T> parameter) {
        Expression expression = this.parser.parseExpression(parameter.getKey());
        return (T)expression.getValue(this.context);
    }
}

