/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.persistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateProvider {
    private static final ThreadLocal stateHolder = new ThreadLocal();

    private StateProvider() {
    }

    public static <STATE> void setUnderlyingState(STATE state) {
        if (stateHolder.get() != null) {
            throw new IllegalStateException("StateHolder already contains state " + stateHolder.get() + " in thread " + Thread.currentThread());
        }
        stateHolder.set(state);
    }

    public static <STATE> STATE retrieveState() {
        Object result = stateHolder.get();
        stateHolder.remove();
        return (STATE)result;
    }
}

