/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CdiRepositoryBean<T>
implements Bean<T> {
    private static final Log LOG = LogFactory.getLog(CdiRepositoryBean.class);
    private final Set<Annotation> qualifiers;
    private final Class<T> repositoryType;
    private final BeanManager beanManager;

    public CdiRepositoryBean(Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager) {
        Assert.notNull(qualifiers);
        Assert.notNull((Object)beanManager);
        Assert.notNull(repositoryType);
        Assert.isTrue((boolean)repositoryType.isInterface());
        this.qualifiers = qualifiers;
        this.repositoryType = repositoryType;
        this.beanManager = beanManager;
    }

    public Set<Type> getTypes() {
        HashSet interfaces = new HashSet();
        interfaces.add(this.repositoryType);
        interfaces.addAll(Arrays.asList(this.repositoryType.getInterfaces()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Declaring types '%s' for repository '%s'.", ((Object)interfaces).toString(), this.repositoryType.getName()));
        }
        return new HashSet<Type>(interfaces);
    }

    protected <S> S getDependencyInstance(Bean<S> bean, Class<S> type) {
        CreationalContext creationalContext = this.beanManager.createCreationalContext(bean);
        return (S)this.beanManager.getReference(bean, type, creationalContext);
    }

    public final T create(CreationalContext<T> creationalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Creating bean instance for repository type '%s'.", this.repositoryType.getName()));
        }
        return this.create(creationalContext, this.repositoryType);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Destroying bean instance %s for repository type '%s'.", instance.toString(), this.repositoryType.getName()));
        }
        creationalContext.release();
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getName() {
        return this.repositoryType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        HashSet<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : this.repositoryType.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Stereotype.class)) continue;
            stereotypes.add(annotationType);
        }
        return stereotypes;
    }

    public Class<?> getBeanClass() {
        return this.repositoryType;
    }

    public boolean isAlternative() {
        return this.repositoryType.isAnnotationPresent(Alternative.class);
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    protected abstract T create(CreationalContext<T> var1, Class<T> var2);

    public String toString() {
        return String.format("JpaRepositoryBean: type='%s', qualifiers=%s", this.repositoryType.getName(), this.qualifiers.toString());
    }
}

