/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TypeFilterParser {
    private static final String FILTER_TYPE_ATTRIBUTE = "type";
    private static final String FILTER_EXPRESSION_ATTRIBUTE = "expression";
    private final ClassLoader classLoader;
    private final ReaderContext readerContext;

    public TypeFilterParser(ClassLoader classLoader, ReaderContext readerContext) {
        this.classLoader = classLoader;
        this.readerContext = readerContext;
    }

    public void parseFilters(Element element, ClassPathScanningCandidateComponentProvider scanner) {
        this.parseTypeFilters(element, scanner, Type.INCLUDE);
        this.parseTypeFilters(element, scanner, Type.EXCLUDE);
    }

    private void parseTypeFilters(Element element, ClassPathScanningCandidateComponentProvider scanner, Type type) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Element childElement = type.getElement(node);
            if (childElement == null) continue;
            try {
                type.addFilter(this.createTypeFilter((Element)node, this.classLoader), scanner);
                continue;
            }
            catch (RuntimeException e) {
                this.readerContext.error(e.getMessage(), this.readerContext.extractSource((Object)element), e.getCause());
            }
        }
    }

    protected TypeFilter createTypeFilter(Element element, ClassLoader classLoader) {
        String filterType = element.getAttribute(FILTER_TYPE_ATTRIBUTE);
        String expression = element.getAttribute(FILTER_EXPRESSION_ATTRIBUTE);
        try {
            FilterType filter = FilterType.fromString(filterType);
            return filter.getFilter(expression, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new FatalBeanException("Type filter class not found: " + expression, (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        INCLUDE("include-filter"){

            public void addFilter(TypeFilter filter, ClassPathScanningCandidateComponentProvider scanner) {
                scanner.addIncludeFilter(filter);
            }
        }
        ,
        EXCLUDE("exclude-filter"){

            public void addFilter(TypeFilter filter, ClassPathScanningCandidateComponentProvider scanner) {
                scanner.addExcludeFilter(filter);
            }
        };

        private String elementName;

        private Type(String elementName) {
            this.elementName = elementName;
        }

        Element getElement(Node node) {
            String localName;
            if (node.getNodeType() == 1 && this.elementName.equals(localName = node.getLocalName())) {
                return (Element)node;
            }
            return null;
        }

        abstract void addFilter(TypeFilter var1, ClassPathScanningCandidateComponentProvider var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterType {
        ANNOTATION{

            public TypeFilter getFilter(String expression, ClassLoader classLoader) throws ClassNotFoundException {
                return new AnnotationTypeFilter(classLoader.loadClass(expression));
            }
        }
        ,
        ASSIGNABLE{

            public TypeFilter getFilter(String expression, ClassLoader classLoader) throws ClassNotFoundException {
                return new AssignableTypeFilter(classLoader.loadClass(expression));
            }
        }
        ,
        ASPECTJ{

            public TypeFilter getFilter(String expression, ClassLoader classLoader) {
                return new AspectJTypeFilter(expression, classLoader);
            }
        }
        ,
        REGEX{

            public TypeFilter getFilter(String expression, ClassLoader classLoader) {
                return new RegexPatternTypeFilter(Pattern.compile(expression));
            }
        }
        ,
        CUSTOM{

            public TypeFilter getFilter(String expression, ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> filterClass = classLoader.loadClass(expression);
                if (!TypeFilter.class.isAssignableFrom(filterClass)) {
                    throw new IllegalArgumentException("Class is not assignable to [" + TypeFilter.class.getName() + "]: " + expression);
                }
                return (TypeFilter)BeanUtils.instantiateClass(filterClass);
            }
        };


        abstract TypeFilter getFilter(String var1, ClassLoader var2) throws ClassNotFoundException;

        static FilterType fromString(String typeString) {
            for (FilterType filter : FilterType.values()) {
                if (!filter.name().equalsIgnoreCase(typeString)) continue;
                return filter;
            }
            throw new IllegalArgumentException("Unsupported filter type: " + typeString);
        }
    }
}

