/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultRepositoryInformation
extends AbstractRepositoryMetadata
implements RepositoryInformation {
    private static final TypeVariable<Class<Repository>>[] PARAMETERS = Repository.class.getTypeParameters();
    private static final String DOMAIN_TYPE_NAME = PARAMETERS[0].getName();
    private static final String ID_TYPE_NAME = PARAMETERS[1].getName();
    private final Map<Method, Method> methodCache = new ConcurrentHashMap<Method, Method>();
    private final RepositoryMetadata metadata;
    private final Class<?> repositoryBaseClass;
    private final Class<?> customImplementationClass;

    public DefaultRepositoryInformation(RepositoryMetadata metadata, Class<?> repositoryBaseClass, Class<?> customImplementationClass) {
        super(metadata.getRepositoryInterface());
        Assert.notNull((Object)metadata);
        Assert.notNull(repositoryBaseClass);
        this.metadata = metadata;
        this.repositoryBaseClass = repositoryBaseClass;
        this.customImplementationClass = customImplementationClass;
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.metadata.getRepositoryInterface();
    }

    @Override
    public Class<?> getDomainClass() {
        return this.metadata.getDomainClass();
    }

    @Override
    public Class<?> getIdClass() {
        return this.metadata.getIdClass();
    }

    @Override
    public Class<?> getRepositoryBaseClass() {
        return this.repositoryBaseClass;
    }

    @Override
    public Method getTargetClassMethod(Method method) {
        if (this.methodCache.containsKey(method)) {
            return this.methodCache.get(method);
        }
        Method result = this.getTargetClassMethod(method, this.customImplementationClass);
        if (!result.equals(method)) {
            this.methodCache.put(method, result);
            return result;
        }
        result = this.getTargetClassMethod(method, this.repositoryBaseClass);
        this.methodCache.put(method, result);
        return result;
    }

    private boolean isTargetClassMethod(Method method, Class<?> targetType) {
        Assert.notNull((Object)method);
        if (targetType == null) {
            return false;
        }
        if (method.getDeclaringClass().isAssignableFrom(targetType)) {
            return true;
        }
        return !method.equals(this.getTargetClassMethod(method, targetType));
    }

    @Override
    public Iterable<Method> getQueryMethods() {
        HashSet<Method> result = new HashSet<Method>();
        for (Method method : this.getRepositoryInterface().getMethods()) {
            if (this.isCustomMethod(method) || this.isBaseClassMethod(method)) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    public boolean isCustomMethod(Method method) {
        return this.isTargetClassMethod(method, this.customImplementationClass);
    }

    public boolean isBaseClassMethod(Method method) {
        return this.isTargetClassMethod(method, this.repositoryBaseClass);
    }

    Method getTargetClassMethod(Method method, Class<?> baseClass) {
        if (baseClass == null) {
            return method;
        }
        for (Method baseClassMethod : baseClass.getMethods()) {
            if (!method.getName().equals(baseClassMethod.getName()) || method.getParameterTypes().length != baseClassMethod.getParameterTypes().length || !this.parametersMatch(method, baseClassMethod)) continue;
            return baseClassMethod;
        }
        return method;
    }

    @Override
    public boolean hasCustomMethod() {
        Class<?> repositoryInterface = this.getRepositoryInterface();
        if (ClassUtils.isGenericRepositoryInterface(repositoryInterface)) {
            return false;
        }
        for (Method method : repositoryInterface.getMethods()) {
            if (!this.isCustomMethod(method) || this.isBaseClassMethod(method)) continue;
            return true;
        }
        return false;
    }

    private boolean parametersMatch(Method method, Method baseClassMethod) {
        Type[] genericTypes = baseClassMethod.getGenericParameterTypes();
        Class<?>[] types = baseClassMethod.getParameterTypes();
        for (int i = 0; i < genericTypes.length; ++i) {
            String name;
            Type type = genericTypes[i];
            MethodParameter parameter = new MethodParameter(method, i);
            Class parameterType = GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.metadata.getRepositoryInterface());
            if (!(type instanceof TypeVariable ? !this.matchesGenericType(name = ((TypeVariable)type).getName(), parameterType) : !types[i].equals(parameterType))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesGenericType(String name, Class<?> parameterType) {
        Class<?> entityType = this.getDomainClass();
        Class<?> idClass = this.getIdClass();
        if (ID_TYPE_NAME.equals(name) && parameterType.equals(idClass)) {
            return true;
        }
        return DOMAIN_TYPE_NAME.equals(name) && parameterType.equals(entityType);
    }
}

