/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassConverter
implements ConditionalGenericConverter,
ApplicationContextAware {
    private final Map<EntityInformation<?, Serializable>, CrudRepository<?, Serializable>> repositories = new HashMap();
    private final ConversionService service;

    public DomainClassConverter(ConversionService service) {
        this.service = service;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        EntityInformation<?, Serializable> info = this.getRepositoryForDomainType(targetType.getType());
        CrudRepository<?, Serializable> repository = this.repositories.get(info);
        Serializable id = (Serializable)this.service.convert(source, info.getIdType());
        return repository.findOne(id);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        EntityInformation<?, Serializable> info = this.getRepositoryForDomainType(targetType.getType());
        if (info == null) {
            return false;
        }
        return this.service.canConvert(sourceType.getType(), info.getIdType());
    }

    private EntityInformation<?, Serializable> getRepositoryForDomainType(Class<?> domainType) {
        for (EntityInformation<?, Serializable> information : this.repositories.keySet()) {
            if (!domainType.equals(information.getJavaType())) continue;
            return information;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext context) {
        Collection providers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, RepositoryFactoryInformation.class).values();
        for (RepositoryFactoryInformation entry : providers) {
            EntityInformation metadata = entry.getEntityInformation();
            Class objectType = entry.getRepositoryInterface();
            CrudRepository repository = (CrudRepository)BeanFactoryUtils.beanOfType((ListableBeanFactory)context, objectType);
            this.repositories.put(metadata, repository);
        }
    }
}

