/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.support.DomainClassPropertyEditor;

public class DomainClassPropertyEditorRegistrar
implements PropertyEditorRegistrar,
ApplicationContextAware {
    private final Map<EntityInformation<Object, Serializable>, CrudRepository<Object, Serializable>> repositories = new HashMap<EntityInformation<Object, Serializable>, CrudRepository<Object, Serializable>>();

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        for (Map.Entry<EntityInformation<Object, Serializable>, CrudRepository<Object, Serializable>> entry : this.repositories.entrySet()) {
            EntityInformation<Object, Serializable> metadata = entry.getKey();
            CrudRepository<Object, Serializable> repository = entry.getValue();
            DomainClassPropertyEditor<Object, Serializable> editor = new DomainClassPropertyEditor<Object, Serializable>(repository, metadata, registry);
            registry.registerCustomEditor(metadata.getJavaType(), editor);
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        Collection providers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, RepositoryFactoryInformation.class).values();
        for (RepositoryFactoryInformation information : providers) {
            EntityInformation metadata = information.getEntityInformation();
            Class objectType = information.getRepositoryInterface();
            CrudRepository repository = (CrudRepository)BeanFactoryUtils.beanOfType((ListableBeanFactory)context, objectType);
            this.repositories.put(metadata, repository);
        }
    }
}

