/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.repository.core;

import java.lang.reflect.Method;
import java.util.Collection;

/**
 * Metadata for repository interfaces.
 * 
 * @author Oliver Gierke
 */
public interface RepositoryMetadata {

	/**
	 * Returns the id class the given class is declared for.
	 * 
	 * @param clazz
	 * @return the id class of the entity managed by the repository for or {@code null} if none found.
	 */
	Class<?> getIdClass();

	/**
	 * Returns the domain class the repository is declared for.
	 * 
	 * @param clazz
	 * @return the domain class the repository is handling or {@code null} if none found.
	 */
	Class<?> getDomainClass();

	/**
	 * Returns the repository interface.
	 * 
	 * @return
	 */
	Class<?> getRepositoryInterface();
	
	/**
	 * Returns the domain class returned by the given {@link Method}. Will extract the type from {@link Collection}s and
	 * {@link org.springframework.data.domain.Page} as well.
	 * 
	 * @param method
	 * @return
	 */
	Class<?> getReturnedDomainClass(Method method);
}
