/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class QueryDslUtils {
    public static final boolean QUERY_DSL_PRESENT = ClassUtils.isPresent((String)"com.querydsl.core.types.Predicate", (ClassLoader)QueryDslUtils.class.getClassLoader());

    public static String toDotPath(Path<?> path) {
        return QueryDslUtils.toDotPath(path, "");
    }

    private static String toDotPath(Path<?> path, String tail) {
        if (path == null) {
            return tail;
        }
        PathMetadata metadata = path.getMetadata();
        Path parent = metadata.getParent();
        if (parent == null) {
            return tail;
        }
        Object element = metadata.getElement();
        if (element == null || !StringUtils.hasText((String)element.toString())) {
            return QueryDslUtils.toDotPath(parent, tail);
        }
        return QueryDslUtils.toDotPath(parent, StringUtils.hasText((String)tail) ? String.format("%s.%s", element, tail) : element.toString());
    }

    private QueryDslUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

