/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationDetectionFieldCallback
implements ReflectionUtils.FieldCallback {
    private final Class<? extends Annotation> annotationType;
    private Field field;

    public AnnotationDetectionFieldCallback(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"AnnotationType must not be null!");
        this.annotationType = annotationType;
    }

    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (this.field != null) {
            return;
        }
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, this.annotationType);
        if (annotation != null) {
            this.field = field;
            ReflectionUtils.makeAccessible((Field)this.field);
        }
    }

    public Class<?> getType() {
        return this.field == null ? null : this.field.getType();
    }

    public <T> T getValue(Object source) {
        Assert.notNull((Object)source, (String)"Source object must not be null!");
        return (T)(this.field == null ? null : ReflectionUtils.getField((Field)this.field, (Object)source));
    }
}

