/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.MappingContextTypeInformationMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class DefaultTypeMapper<S>
implements TypeMapper<S> {
    private final TypeAliasAccessor<S> accessor;
    private final List<? extends TypeInformationMapper> mappers;
    private final Map<Object, TypeInformation<?>> typeCache;

    public DefaultTypeMapper(TypeAliasAccessor<S> accessor) {
        this(accessor, Arrays.asList(new SimpleTypeInformationMapper()));
    }

    public DefaultTypeMapper(TypeAliasAccessor<S> accessor, List<? extends TypeInformationMapper> mappers) {
        this(accessor, null, mappers);
    }

    public DefaultTypeMapper(TypeAliasAccessor<S> accessor, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> additionalMappers) {
        Assert.notNull(accessor, (String)"Accessor must not be null!");
        Assert.notNull(additionalMappers, (String)"AdditionalMappers must not be null!");
        ArrayList<? extends TypeInformationMapper> mappers = new ArrayList<TypeInformationMapper>(additionalMappers.size() + 1);
        if (mappingContext != null) {
            mappers.add(new MappingContextTypeInformationMapper(mappingContext));
        }
        mappers.addAll(additionalMappers);
        this.mappers = Collections.unmodifiableList(mappers);
        this.accessor = accessor;
        this.typeCache = new ConcurrentHashMap();
    }

    @Override
    public TypeInformation<?> readType(S source) {
        Assert.notNull(source, (String)"Source object must not be null!");
        Object alias = this.accessor.readAliasFrom(source);
        return alias == null ? null : this.getFromCacheOrCreate(alias);
    }

    private TypeInformation<?> getFromCacheOrCreate(Object alias) {
        TypeInformation<?> typeInformation = this.typeCache.get(alias);
        if (typeInformation != null) {
            return typeInformation;
        }
        for (TypeInformationMapper typeInformationMapper : this.mappers) {
            typeInformation = typeInformationMapper.resolveTypeFrom(alias);
            if (typeInformation == null) continue;
            this.typeCache.put(alias, typeInformation);
            return typeInformation;
        }
        return typeInformation;
    }

    @Override
    public <T> TypeInformation<? extends T> readType(S source, TypeInformation<T> basicType) {
        boolean isMoreConcreteCustomType;
        Class<T> rawType;
        Assert.notNull(source, (String)"Source object must not be null!");
        Class<?> documentsTargetType = this.getDefaultedTypeToBeUsed(source);
        if (documentsTargetType == null) {
            return basicType;
        }
        Class<T> clazz = rawType = basicType == null ? null : basicType.getType();
        boolean bl = rawType == null ? true : (isMoreConcreteCustomType = rawType.isAssignableFrom(documentsTargetType) && !rawType.equals(documentsTargetType));
        if (!isMoreConcreteCustomType) {
            return basicType;
        }
        ClassTypeInformation<?> targetType = ClassTypeInformation.from(documentsTargetType);
        return basicType != null ? basicType.specialize(targetType) : targetType;
    }

    private Class<?> getDefaultedTypeToBeUsed(S source) {
        TypeInformation<?> documentsTargetTypeInformation = this.readType(source);
        documentsTargetTypeInformation = documentsTargetTypeInformation == null ? this.getFallbackTypeFor(source) : documentsTargetTypeInformation;
        return documentsTargetTypeInformation == null ? null : documentsTargetTypeInformation.getType();
    }

    protected TypeInformation<?> getFallbackTypeFor(S source) {
        return null;
    }

    @Override
    public void writeType(Class<?> type, S dbObject) {
        this.writeType(ClassTypeInformation.from(type), dbObject);
    }

    @Override
    public void writeType(TypeInformation<?> info, S sink) {
        Assert.notNull(info, (String)"TypeInformation must not be null!");
        Object alias = this.getAliasFor(info);
        if (alias != null) {
            this.accessor.writeTypeTo(sink, alias);
        }
    }

    protected final Object getAliasFor(TypeInformation<?> info) {
        Assert.notNull(info, (String)"TypeInformation must not be null!");
        for (TypeInformationMapper typeInformationMapper : this.mappers) {
            Object alias = typeInformationMapper.createAliasFor(info);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }
}

