/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import com.couchbase.client.CouchbaseClient;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class CouchbaseCache
implements Cache {
    private final CouchbaseClient client;
    private final String name;

    public CouchbaseCache(String name, CouchbaseClient client) {
        this.name = name;
        this.client = client;
    }

    public final String getName() {
        return this.name;
    }

    public final CouchbaseClient getNativeCache() {
        return this.client;
    }

    public final Cache.ValueWrapper get(Object key) {
        String documentId = key.toString();
        Object result = this.client.get(documentId);
        return result != null ? new SimpleValueWrapper(result) : null;
    }

    public final void put(Object key, Object value) {
        if (value != null) {
            String documentId = key.toString();
            this.client.set(documentId, 0, value);
        } else {
            this.evict(key);
        }
    }

    public final void evict(Object key) {
        String documentId = key.toString();
        this.client.delete(documentId);
    }

    public final void clear() {
        this.client.flush();
    }
}

