/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CouchbaseTemplateParser
extends AbstractSingleBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "couchbaseTemplate";
    }

    protected Class getBeanClass(Element element) {
        return CouchbaseTemplate.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder bean) {
        String clientRef = element.getAttribute("client-ref");
        String converterRef = element.getAttribute("converter-ref");
        String translationServiceRef = element.getAttribute("translation-service-ref");
        bean.addConstructorArgReference(StringUtils.hasText((String)clientRef) ? clientRef : "couchbase");
        if (StringUtils.hasText((String)converterRef)) {
            bean.addConstructorArgReference(converterRef);
        }
        if (StringUtils.hasText((String)translationServiceRef)) {
            bean.addConstructorArgReference(translationServiceRef);
        }
    }
}

