/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class CouchbaseDocument
implements CouchbaseStorable {
    public static final int DEFAULT_EXPIRATION_TIME = 0;
    private HashMap<String, Object> payload;
    private String id;
    private int expiration;
    private SimpleTypeHolder simpleTypeHolder;

    public CouchbaseDocument() {
        this(null);
    }

    public CouchbaseDocument(String id) {
        this(id, 0);
    }

    public CouchbaseDocument(String id, int expiration) {
        this.id = id;
        this.expiration = expiration;
        this.payload = new HashMap();
        HashSet<Class> additionalTypes = new HashSet<Class>();
        additionalTypes.add(CouchbaseDocument.class);
        additionalTypes.add(CouchbaseList.class);
        this.simpleTypeHolder = new SimpleTypeHolder(additionalTypes, true);
    }

    public final CouchbaseDocument put(String key, Object value) {
        this.verifyValueType(value);
        this.payload.put(key, value);
        return this;
    }

    public final Object get(String key) {
        return this.payload.get(key);
    }

    public final HashMap<String, Object> export() {
        HashMap<String, Object> toExport = new HashMap<String, Object>(this.payload);
        for (Map.Entry<String, Object> entry : this.payload.entrySet()) {
            if (entry.getValue() instanceof CouchbaseDocument) {
                toExport.put(entry.getKey(), ((CouchbaseDocument)entry.getValue()).export());
                continue;
            }
            if (!(entry.getValue() instanceof CouchbaseList)) continue;
            toExport.put(entry.getKey(), ((CouchbaseList)entry.getValue()).export());
        }
        return toExport;
    }

    public final boolean containsKey(String key) {
        return this.payload.containsKey(key);
    }

    public final boolean containsValue(Object value) {
        return this.payload.containsValue(value);
    }

    public final int size() {
        return this.size(false);
    }

    public final int size(boolean recursive) {
        int thisSize = this.payload.size();
        if (!recursive || thisSize == 0) {
            return thisSize;
        }
        int totalSize = thisSize;
        for (Object value : this.payload.values()) {
            if (value instanceof CouchbaseDocument) {
                totalSize += ((CouchbaseDocument)value).size(true);
                continue;
            }
            if (!(value instanceof CouchbaseList)) continue;
            totalSize += ((CouchbaseList)value).size(true);
        }
        return totalSize;
    }

    public HashMap<String, Object> getPayload() {
        return this.payload;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public CouchbaseDocument setExpiration(int expiration) {
        this.expiration = expiration;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CouchbaseDocument setId(String id) {
        this.id = id;
        return this;
    }

    private void verifyValueType(Object value) {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (this.simpleTypeHolder.isSimpleType(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Attribute of type " + clazz.getCanonicalName() + " cannot be stored and must be converted.");
    }

    public String toString() {
        return "CouchbaseDocument{id=" + this.id + ", exp=" + this.expiration + ", payload=" + this.payload + '}';
    }
}

