/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.protocol.views.Query;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.StringUtils;

public class ViewBasedCouchbaseQuery
implements RepositoryQuery {
    private final CouchbaseQueryMethod method;
    private final CouchbaseOperations operations;

    public ViewBasedCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] runtimeParams) {
        Query query = null;
        for (Object param : runtimeParams) {
            if (!(param instanceof Query)) {
                throw new IllegalStateException("Unknown query param: " + param);
            }
            query = (Query)param;
        }
        if (query == null) {
            query = new Query();
        }
        query.setReduce(Boolean.valueOf(false));
        return this.operations.findByView(this.designDocName(), this.viewName(), query, this.method.getEntityInformation().getJavaType());
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    private String designDocName() {
        if (this.method.hasViewAnnotation()) {
            return this.method.getViewAnnotation().designDocument();
        }
        return StringUtils.uncapitalize((String)this.method.getEntityInformation().getJavaType().getSimpleName());
    }

    private String viewName() {
        if (this.method.hasViewAnnotation()) {
            return this.method.getViewAnnotation().viewName();
        }
        return StringUtils.uncapitalize((String)this.method.getName().replaceFirst("find", ""));
    }
}

