/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.PartTreeN1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlQueryCreatorUtils;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlQueryCreator
extends AbstractQueryCreator<LimitPath, Expression>
implements PartTreeN1qlQueryCreator {
    private final WherePath selectFrom;
    private final CouchbaseConverter converter;
    private final CouchbaseQueryMethod queryMethod;
    private final ParameterAccessor accessor;
    private final JsonArray placeHolderValues;
    private final AtomicInteger position;

    public N1qlQueryCreator(PartTree tree, ParameterAccessor parameters, WherePath selectFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, parameters);
        this.selectFrom = selectFrom;
        this.converter = converter;
        this.queryMethod = queryMethod;
        this.accessor = parameters;
        this.placeHolderValues = JsonArray.create();
        this.position = new AtomicInteger(1);
    }

    protected Expression create(Part part, Iterator<Object> iterator) {
        return N1qlQueryCreatorUtils.prepareExpression(this.converter, part, iterator, this.position, this.placeHolderValues);
    }

    protected Expression and(Part part, Expression base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        return base.and(this.create(part, iterator));
    }

    protected Expression or(Expression base, Expression criteria) {
        return base.or(criteria);
    }

    protected LimitPath complete(Expression criteria, Sort sort) {
        Pageable pageable;
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(criteria, this.converter, this.queryMethod.getEntityInformation());
        GroupByPath selectFromWhere = this.selectFrom.where(whereCriteria);
        if ((this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) && this.accessor.getPageable() != null && (pageable = this.accessor.getPageable()).getSort() != null) {
            sort = pageable.getSort();
        }
        if (sort != null) {
            com.couchbase.client.java.query.dsl.Sort[] cbSorts = N1qlUtils.createSort(sort, this.converter);
            return selectFromWhere.orderBy(cbSorts);
        }
        return selectFromWhere;
    }

    @Override
    public JsonValue getPlaceHolderValues() {
        return this.placeHolderValues;
    }
}

