/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import com.couchbase.client.java.codec.SerializableTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.couchbase.cache.CacheKeyPrefix;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;

public class CouchbaseCacheConfiguration {
    private final Duration expiry;
    private final boolean cacheNullValues;
    private final CacheKeyPrefix keyPrefix;
    private final boolean usePrefix;
    private final Transcoder valueTranscoder;
    private final ConversionService conversionService;
    private final String collectionName;

    private CouchbaseCacheConfiguration(Duration expiry, boolean cacheNullValues, boolean usePrefix, CacheKeyPrefix keyPrefix, ConversionService conversionService, Transcoder valueTranscoder, String collectionName) {
        this.expiry = expiry;
        this.cacheNullValues = cacheNullValues;
        this.usePrefix = usePrefix;
        this.keyPrefix = keyPrefix;
        this.conversionService = conversionService;
        this.valueTranscoder = valueTranscoder;
        this.collectionName = collectionName;
    }

    public static CouchbaseCacheConfiguration defaultCacheConfig() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        CouchbaseCacheConfiguration.registerDefaultConverters((ConverterRegistry)conversionService);
        return new CouchbaseCacheConfiguration(Duration.ZERO, true, true, CacheKeyPrefix.simple(), (ConversionService)conversionService, (Transcoder)SerializableTranscoder.INSTANCE, null);
    }

    public static void registerDefaultConverters(ConverterRegistry registry) {
        Assert.notNull((Object)registry, (String)"ConverterRegistry must not be null!");
        registry.addConverter(String.class, byte[].class, source -> source.getBytes(StandardCharsets.UTF_8));
        registry.addConverter(SimpleKey.class, String.class, SimpleKey::toString);
    }

    public CouchbaseCacheConfiguration entryExpiry(Duration expiry) {
        Assert.notNull((Object)expiry, (String)"Expiry duration must not be null!");
        return new CouchbaseCacheConfiguration(expiry, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.conversionService, this.valueTranscoder, this.collectionName);
    }

    public CouchbaseCacheConfiguration valueTranscoder(Transcoder valueTranscoder) {
        Assert.notNull((Object)valueTranscoder, (String)"Transcoder must not be null!");
        return new CouchbaseCacheConfiguration(this.expiry, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.conversionService, valueTranscoder, this.collectionName);
    }

    public CouchbaseCacheConfiguration disableCachingNullValues() {
        return new CouchbaseCacheConfiguration(this.expiry, false, this.usePrefix, this.keyPrefix, this.conversionService, this.valueTranscoder, this.collectionName);
    }

    public CouchbaseCacheConfiguration prefixCacheNameWith(String prefix) {
        return this.computePrefixWith(CacheKeyPrefix.prefixed(prefix));
    }

    public CouchbaseCacheConfiguration computePrefixWith(CacheKeyPrefix cacheKeyPrefix) {
        Assert.notNull((Object)cacheKeyPrefix, (String)"Function for computing prefix must not be null!");
        return new CouchbaseCacheConfiguration(this.expiry, this.cacheNullValues, true, cacheKeyPrefix, this.conversionService, this.valueTranscoder, this.collectionName);
    }

    public Duration getExpiry() {
        return this.expiry;
    }

    public boolean getAllowCacheNullValues() {
        return this.cacheNullValues;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public boolean usePrefix() {
        return this.usePrefix;
    }

    public String getKeyPrefixFor(String cacheName) {
        Assert.notNull((Object)cacheName, (String)"Cache name must not be null!");
        return this.keyPrefix.compute(cacheName);
    }

    public Transcoder getValueTranscoder() {
        return this.valueTranscoder;
    }

    public String getCollectionName() {
        return this.collectionName;
    }
}

