/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperationSupport;
import org.springframework.data.couchbase.core.query.Query;

public class ExecutableFindByQueryOperationSupport
implements ExecutableFindByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final CouchbaseTemplate template;

    public ExecutableFindByQueryOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByQueryOperation.ExecutableFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ExecutableFindByQuerySupport<T>(this.template, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED);
    }

    static class ExecutableFindByQuerySupport<T>
    implements ExecutableFindByQueryOperation.ExecutableFindByQuery<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final ReactiveFindByQueryOperationSupport.ReactiveFindByQuerySupport<T> reactiveSupport;
        private final QueryScanConsistency scanConsistency;

        ExecutableFindByQuerySupport(CouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.reactiveSupport = new ReactiveFindByQueryOperationSupport.ReactiveFindByQuerySupport<T>(template.reactive(), domainType, query, scanConsistency);
            this.scanConsistency = scanConsistency;
        }

        @Override
        public T oneValue() {
            return (T)this.reactiveSupport.one().block();
        }

        @Override
        public T firstValue() {
            return (T)this.reactiveSupport.first().block();
        }

        @Override
        public List<T> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableFindByQueryOperation.TerminatingFindByQuery<T> matching(Query query) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryWithQuery<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }

        @Override
        public Stream<T> stream() {
            return this.reactiveSupport.all().toStream();
        }

        @Override
        public long count() {
            return (Long)this.reactiveSupport.count().block();
        }

        @Override
        public boolean exists() {
            return this.count() > 0L;
        }
    }
}

