/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Collection;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperationSupport;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.util.Assert;

public class ExecutableRemoveByIdOperationSupport
implements ExecutableRemoveByIdOperation {
    private final CouchbaseTemplate template;

    public ExecutableRemoveByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById() {
        return new ExecutableRemoveByIdSupport(this.template, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE);
    }

    static class ExecutableRemoveByIdSupport
    implements ExecutableRemoveByIdOperation.ExecutableRemoveById {
        private final CouchbaseTemplate template;
        private final String collection;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final ReactiveRemoveByIdOperationSupport.ReactiveRemoveByIdSupport reactiveRemoveByIdSupport;

        ExecutableRemoveByIdSupport(CouchbaseTemplate template, String collection, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel) {
            this.template = template;
            this.collection = collection;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.reactiveRemoveByIdSupport = new ReactiveRemoveByIdOperationSupport.ReactiveRemoveByIdSupport(template.reactive(), collection, persistTo, replicateTo, durabilityLevel);
        }

        @Override
        public RemoveResult one(String id) {
            return (RemoveResult)this.reactiveRemoveByIdSupport.one(id).block();
        }

        @Override
        public List<RemoveResult> all(Collection<String> ids) {
            return (List)this.reactiveRemoveByIdSupport.all(ids).collectList().block();
        }

        @Override
        public ExecutableRemoveByIdOperation.TerminatingRemoveById inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableRemoveByIdSupport(this.template, collection, this.persistTo, this.replicateTo, this.durabilityLevel);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdWithCollection withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.collection, this.persistTo, this.replicateTo, durabilityLevel);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdWithCollection withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.collection, persistTo, replicateTo, this.durabilityLevel);
        }
    }
}

