/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Collection;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableReplaceByIdOperation;
import org.springframework.data.couchbase.core.ReactiveReplaceByIdOperationSupport;
import org.springframework.util.Assert;

public class ExecutableReplaceByIdOperationSupport
implements ExecutableReplaceByIdOperation {
    private final CouchbaseTemplate template;

    public ExecutableReplaceByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableReplaceByIdOperation.ExecutableReplaceById<T> replaceById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableReplaceByIdSupport<T>(this.template, domainType, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE);
    }

    static class ExecutableReplaceByIdSupport<T>
    implements ExecutableReplaceByIdOperation.ExecutableReplaceById<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final ReactiveReplaceByIdOperationSupport.ReactiveReplaceByIdSupport<T> reactiveSupport;

        ExecutableReplaceByIdSupport(CouchbaseTemplate template, Class<T> domainType, String collection, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.reactiveSupport = new ReactiveReplaceByIdOperationSupport.ReactiveReplaceByIdSupport<T>(template.reactive(), domainType, collection, persistTo, replicateTo, durabilityLevel);
        }

        @Override
        public T one(T object) {
            return (T)this.reactiveSupport.one(object).block();
        }

        @Override
        public Collection<? extends T> all(Collection<? extends T> objects) {
            return (Collection)this.reactiveSupport.all(objects).collectList().block();
        }

        @Override
        public ExecutableReplaceByIdOperation.TerminatingReplaceById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableReplaceByIdSupport<T>(this.template, this.domainType, collection, this.persistTo, this.replicateTo, this.durabilityLevel);
        }

        @Override
        public ExecutableReplaceByIdOperation.ReplaceByIdWithCollection<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableReplaceByIdSupport<T>(this.template, this.domainType, this.collection, this.persistTo, this.replicateTo, durabilityLevel);
        }

        @Override
        public ExecutableReplaceByIdOperation.ReplaceByIdWithCollection<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableReplaceByIdSupport<T>(this.template, this.domainType, this.collection, persistTo, replicateTo, this.durabilityLevel);
        }
    }
}

