/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByQueryOperationSupport
implements ReactiveFindByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;

    public ReactiveFindByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByQueryOperation.ReactiveFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ReactiveFindByQuerySupport<T>(this.template, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED);
    }

    static class ReactiveFindByQuerySupport<T>
    implements ReactiveFindByQueryOperation.ReactiveFindByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;

        ReactiveFindByQuerySupport(ReactiveCouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.scanConsistency = scanConsistency;
        }

        @Override
        public ReactiveFindByQueryOperation.TerminatingFindByQuery<T> matching(Query query) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithQuery<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }

        @Override
        public Mono<T> one() {
            return this.all().singleOrEmpty();
        }

        @Override
        public Mono<T> first() {
            return this.all().next();
        }

        @Override
        public Flux<T> all() {
            return Flux.defer(() -> {
                String statement = this.assembleEntityQuery(false);
                return this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.query.buildQueryOptions(this.scanConsistency)).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> {
                    String id = row.getString("__id");
                    long cas = row.getLong("__cas");
                    row.removeKey("__id");
                    row.removeKey("__cas");
                    return this.template.support().decodeEntity(id, row.toString(), cas, this.domainType);
                });
            });
        }

        @Override
        public Mono<Long> count() {
            return Mono.defer(() -> {
                String statement = this.assembleEntityQuery(true);
                return this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.query.buildQueryOptions(this.scanConsistency)).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> row.getLong("__count")).next();
            });
        }

        @Override
        public Mono<Boolean> exists() {
            return this.count().map(count -> count > 0L);
        }

        private String assembleEntityQuery(boolean count) {
            return this.query.toN1qlString(this.template, this.domainType, count);
        }
    }
}

