/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.annotation.Id;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicCouchbasePersistentEntity<T>
extends BasicPersistentEntity<T, CouchbasePersistentProperty>
implements CouchbasePersistentEntity<T>,
EnvironmentAware {
    private Environment environment;

    public BasicCouchbasePersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        this.validateExpirationConfiguration();
    }

    private void validateExpirationConfiguration() {
        Document annotation = this.getType().getAnnotation(Document.class);
        if (annotation != null && annotation.expiry() > 0 && StringUtils.hasLength((String)annotation.expiryExpression())) {
            String msg = String.format("Incorrect expiry configuration on class %s using %s. You cannot use 'expiry' and 'expiryExpression' at the same time", this.getType().getName(), annotation);
            throw new IllegalArgumentException(msg);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected CouchbasePersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(CouchbasePersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (!this.hasIdProperty()) {
            return property;
        }
        boolean currentCbId = ((CouchbasePersistentProperty)this.getIdProperty()).isAnnotationPresent(Id.class);
        boolean currentSpringId = ((CouchbasePersistentProperty)this.getIdProperty()).isAnnotationPresent(Id.class);
        boolean candidateCbId = property.isAnnotationPresent(Id.class);
        boolean candidateSpringId = property.isAnnotationPresent(Id.class);
        if (currentCbId && candidateSpringId) {
            return property;
        }
        if (currentSpringId && candidateCbId) {
            return null;
        }
        return (CouchbasePersistentProperty)super.returnPropertyIfBetterIdPropertyCandidateOrNull((PersistentProperty)property);
    }

    @Override
    public int getExpiry() {
        Document annotation = this.getType().getAnnotation(Document.class);
        if (annotation == null) {
            return 0;
        }
        int expiryValue = this.getExpiryValue(annotation);
        long secondsShift = annotation.expiryUnit().toSeconds(expiryValue);
        if (secondsShift > 2592000L) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (annotation.expiryUnit() == TimeUnit.DAYS) {
                cal.add(5, expiryValue);
            } else {
                cal.add(13, (int)secondsShift);
            }
            return (int)(cal.getTimeInMillis() / 1000L);
        }
        return (int)secondsShift;
    }

    private int getExpiryValue(Document annotation) {
        int expiryValue = annotation.expiry();
        String expiryExpressionString = annotation.expiryExpression();
        if (StringUtils.hasLength((String)expiryExpressionString)) {
            Assert.notNull((Object)this.environment, (String)"Environment must be set to use 'expiryExpression'");
            String expiryWithReplacedPlaceholders = this.environment.resolveRequiredPlaceholders(expiryExpressionString);
            try {
                expiryValue = Integer.parseInt(expiryWithReplacedPlaceholders);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Integer value for expiry expression: " + expiryWithReplacedPlaceholders);
            }
        }
        return expiryValue;
    }

    @Override
    public boolean isTouchOnRead() {
        Document annotation = this.getType().getAnnotation(Document.class);
        return annotation == null ? false : annotation.touchOnRead() && this.getExpiry() > 0;
    }
}

