/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class AnalyticsQuery {
    private long skip;
    private int limit;
    private Sort sort = Sort.unsorted();

    public AnalyticsQuery skip(long skip) {
        this.skip = skip;
        return this;
    }

    public AnalyticsQuery limit(int limit) {
        this.limit = limit;
        return this;
    }

    public AnalyticsQuery with(Pageable pageable) {
        if (pageable.isUnpaged()) {
            return this;
        }
        this.limit = pageable.getPageSize();
        this.skip = pageable.getOffset();
        return this.with(pageable.getSort());
    }

    public AnalyticsQuery with(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        if (sort.isUnsorted()) {
            return this;
        }
        this.sort = this.sort.and(sort);
        return this;
    }

    public void appendSkipAndLimit(StringBuilder sb) {
        if (this.limit > 0) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.skip > 0L) {
            sb.append(" OFFSET ").append(this.skip);
        }
    }

    public void appendSort(StringBuilder sb) {
        if (this.sort.isUnsorted()) {
            return;
        }
        sb.append(" ORDER BY ");
        this.sort.stream().forEach(order -> {
            if (order.isIgnoreCase()) {
                throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case! Couchbase N1QL does not support sorting ignoring case currently!", order.getProperty()));
            }
            sb.append(order.getProperty()).append(" ").append(order.isAscending() ? "ASC," : "DESC,");
        });
        sb.deleteCharAt(sb.length() - 1);
    }
}

