/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonValue;
import java.util.Iterator;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlQueryCreator
extends AbstractQueryCreator<Query, QueryCriteria> {
    private final ParameterAccessor accessor;
    private final MappingContext<?, CouchbasePersistentProperty> context;
    private final QueryMethod queryMethod;
    private final CouchbaseConverter converter;

    public N1qlQueryCreator(PartTree tree, ParameterAccessor accessor, QueryMethod queryMethod, CouchbaseConverter converter) {
        super(tree, accessor);
        this.accessor = accessor;
        this.context = converter.getMappingContext();
        this.queryMethod = queryMethod;
        this.converter = converter;
    }

    protected QueryCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, QueryCriteria.where(path.toDotPath()), iterator);
    }

    protected QueryCriteria and(Part part, QueryCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(path.toDotPath()), iterator);
    }

    protected QueryCriteria or(QueryCriteria base, QueryCriteria criteria) {
        return base.or(criteria);
    }

    protected Query complete(QueryCriteria criteria, Sort sort) {
        JsonArray params = (JsonArray)this.getPositionalPlaceholderValues(this.accessor);
        return (criteria == null ? new Query() : new Query().addCriteria(criteria)).with(sort).setPositionalParameters(params);
    }

    private QueryCriteria from(Part part, CouchbasePersistentProperty property, QueryCriteria criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case GREATER_THAN: 
            case AFTER: {
                return criteria.gt(parameters.next());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.next());
            }
            case LESS_THAN: 
            case BEFORE: {
                return criteria.lt(parameters.next());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.next());
            }
            case SIMPLE_PROPERTY: {
                return criteria.eq(parameters.next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.ne(parameters.next());
            }
            case CONTAINING: {
                return criteria.containing(parameters.next());
            }
            case NOT_CONTAINING: {
                return criteria.notContaining(parameters.next());
            }
            case STARTING_WITH: {
                return criteria.startingWith(parameters.next());
            }
            case ENDING_WITH: {
                return criteria.endingWith(parameters.next());
            }
            case LIKE: {
                return criteria.like(parameters.next());
            }
            case NOT_LIKE: {
                return criteria.notLike(parameters.next());
            }
            case WITHIN: {
                return criteria.within(parameters.next());
            }
            case IS_NULL: {
                return criteria.isNull();
            }
            case IS_NOT_NULL: {
                return criteria.isNotNull();
            }
            case IS_EMPTY: {
                return criteria.isNotValued();
            }
            case IS_NOT_EMPTY: {
                return criteria.isValued();
            }
            case EXISTS: {
                return criteria.isNotMissing();
            }
            case REGEX: {
                return criteria.regex(parameters.next());
            }
            case BETWEEN: {
                return criteria.between(parameters.next(), parameters.next());
            }
            case IN: {
                return criteria.in((Object[])parameters.next());
            }
            case NOT_IN: {
                return criteria.notIn((Object[])parameters.next());
            }
            case TRUE: {
                return criteria.TRUE();
            }
            case FALSE: {
                return criteria.FALSE();
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private JsonValue getPositionalPlaceholderValues(ParameterAccessor accessor) {
        JsonArray posValues = JsonArray.create();
        if (this.queryMethod == null) {
            return posValues;
        }
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            try {
                posValues.add(this.converter.convertForWriteIfNeeded(accessor.getBindableValue(parameter.getIndex())));
            }
            catch (InvalidArgumentException iae) {
                Object[] array;
                Object o = accessor.getBindableValue(parameter.getIndex());
                if (!(o instanceof Object[])) continue;
                for (Object e : array = (Object[])o) {
                    posValues.add(this.converter.convertForWriteIfNeeded(e));
                }
            }
        }
        return posValues;
    }
}

