/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonValue;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveAbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ReactiveStringN1qlBasedQuery
extends ReactiveAbstractN1qlBasedQuery {
    private final StringBasedN1qlQueryParser queryParser;
    private final SpelExpressionParser parser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public ReactiveStringN1qlBasedQuery(String statement, CouchbaseQueryMethod queryMethod, ReactiveCouchbaseOperations couchbaseOperations, SpelExpressionParser spelParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, couchbaseOperations);
        this.queryParser = new StringBasedN1qlQueryParser(statement, queryMethod, this.getCouchbaseOperations().getBucketName(), this.getCouchbaseOperations().getConverter(), this.getTypeField(), this.getTypeValue());
        this.parser = spelParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    protected String getTypeField() {
        return this.getCouchbaseOperations().getConverter().getTypeKey();
    }

    protected String getTypeValue() {
        return this.getQueryMethod().getEntityInformation().getJavaType().getName();
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.queryParser.getPlaceholderValues(accessor);
    }

    @Override
    public N1QLExpression getExpression(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        return N1QLExpression.x(this.queryParser.doParse(this.parser, evaluationContext, false));
    }
}

