/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonValue;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.AbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringN1qlBasedQuery
extends AbstractN1qlBasedQuery {
    private final SpelExpressionParser parser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final StringBasedN1qlQueryParser queryParser;

    public StringN1qlBasedQuery(String statement, CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations, SpelExpressionParser spelParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, couchbaseOperations);
        this.queryParser = new StringBasedN1qlQueryParser(statement, queryMethod, this.getCouchbaseOperations().getBucketName(), this.getCouchbaseOperations().getConverter(), this.getTypeField(), this.getTypeValue().getName());
        this.parser = spelParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    protected String getTypeField() {
        return this.getCouchbaseOperations().getConverter().getTypeKey();
    }

    protected Class<?> getTypeValue() {
        return this.getQueryMethod().getEntityInformation().getJavaType();
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.queryParser.getPlaceholderValues(accessor);
    }

    @Override
    public N1QLExpression getExpression(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        Pageable pageable;
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        N1QLExpression parsedStatement = N1QLExpression.x(this.queryParser.doParse(this.parser, evaluationContext, false));
        Sort sort = accessor.getSort();
        if (sort.isSorted()) {
            N1QLExpression[] cbSorts = N1qlUtils.createSort(sort);
            parsedStatement = parsedStatement.orderBy(cbSorts);
        }
        if (this.queryMethod.isPageQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            parsedStatement = parsedStatement.limit(pageable.getPageSize()).offset(Math.toIntExact(pageable.getOffset()));
        } else if (this.queryMethod.isSliceQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            parsedStatement = parsedStatement.limit(pageable.getPageSize() + 1).offset(Math.toIntExact(pageable.getOffset()));
        }
        return parsedStatement;
    }

    @Override
    protected N1QLExpression getCount(ParameterAccessor accessor, Object[] runtimeParameters) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        return N1QLExpression.x(this.queryParser.doParse(this.parser, evaluationContext, true));
    }

    @Override
    protected boolean useGeneratedCountQuery() {
        return this.queryParser.useGeneratedCountQuery();
    }
}

