/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.query.QueryScanConsistency;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryExecution;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.StringN1qlQueryCreator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Deprecated
public class N1qlRepositoryQueryExecutor {
    private final CouchbaseOperations operations;
    private final CouchbaseQueryMethod queryMethod;
    private final NamedQueries namedQueries;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();

    public N1qlRepositoryQueryExecutor(CouchbaseOperations operations, CouchbaseQueryMethod queryMethod, NamedQueries namedQueries, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.operations = operations;
        this.queryMethod = queryMethod;
        this.namedQueries = namedQueries;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public Object execute(Object[] parameters) {
        Query query;
        Class domainClass = this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        if (this.queryMethod.hasN1qlAnnotation()) {
            query = new StringN1qlQueryCreator((ParameterAccessor)accessor, this.queryMethod, this.operations.getConverter(), SPEL_PARSER, this.evaluationContextProvider, this.namedQueries).createQuery();
        } else {
            PartTree tree = new PartTree(this.queryMethod.getName(), domainClass);
            query = new N1qlQueryCreator(tree, (ParameterAccessor)accessor, this.queryMethod, this.operations.getConverter(), this.operations.getBucketName()).createQuery();
        }
        ExecutableFindByQueryOperation.ExecutableFindByQuery operation = (ExecutableFindByQueryOperation.ExecutableFindByQuery)this.operations.findByQuery(domainClass).withConsistency(this.buildQueryScanConsistency());
        if (this.queryMethod.isCountQuery()) {
            return operation.matching(query).count();
        }
        if (this.queryMethod.isCollectionQuery()) {
            return operation.matching(query).all();
        }
        if (this.queryMethod.isPageQuery()) {
            Pageable p = accessor.getPageable();
            return new CouchbaseQueryExecution.PagedExecution(operation, p).execute(query, null, null, null);
        }
        return operation.matching(query).oneValue();
    }

    private QueryScanConsistency buildQueryScanConsistency() {
        QueryScanConsistency scanConsistency = QueryScanConsistency.NOT_BOUNDED;
        if (this.queryMethod.hasConsistencyAnnotation()) {
            scanConsistency = this.queryMethod.getConsistencyAnnotation().value();
        } else if (this.queryMethod.hasScanConsistencyAnnotation()) {
            scanConsistency = this.queryMethod.getScanConsistencyAnnotation().query();
        }
        return scanConsistency;
    }
}

