/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import com.couchbase.client.java.transactions.AttemptContextReactiveAccessor;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import com.couchbase.client.java.transactions.TransactionQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByQueryOperationSupport
implements ReactiveFindByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveFindByQueryOperationSupport.class);

    public ReactiveFindByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByQueryOperation.ReactiveFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ReactiveFindByQuerySupport<T>(this.template, domainType, domainType, ALL_QUERY, null, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, null, null, this.template.support());
    }

    static class ReactiveFindByQuerySupport<T>
    implements ReactiveFindByQueryOperation.ReactiveFindByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;
        private final String collection;
        private final String scope;
        private final String[] distinctFields;
        private final String[] fields;
        private final QueryOptions options;
        private final ReactiveTemplateSupport support;

        ReactiveFindByQuerySupport(ReactiveCouchbaseTemplate template, Class<?> domainType, Class<T> returnType, Query query, QueryScanConsistency scanConsistency, String scope, String collection, QueryOptions options, String[] distinctFields, String[] fields, ReactiveTemplateSupport support) {
            Assert.notNull(domainType, (String)"domainType must not be null!");
            Assert.notNull(returnType, (String)"returnType must not be null!");
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.distinctFields = distinctFields;
            this.fields = fields;
            this.support = support;
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithQuery<T> matching(Query query) {
            QueryScanConsistency scanCons = query.getScanConsistency() != null ? query.getScanConsistency() : this.scanConsistency;
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, query, scanCons, this.scope, this.collection, this.options, this.distinctFields, this.fields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.TerminatingFindByQuery<T> withOptions(QueryOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, options, this.distinctFields, this.fields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryInCollection<T> inScope(String scope) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, scope != null ? scope : this.scope, this.collection, this.options, this.distinctFields, this.fields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithConsistency<T> inCollection(String collection) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, collection != null ? collection : this.collection, this.options, this.distinctFields, this.fields, this.support);
        }

        @Override
        @Deprecated
        public ReactiveFindByQueryOperation.FindByQueryConsistentWith<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.fields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithConsistency<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.fields, this.support);
        }

        @Override
        public <R> ReactiveFindByQueryOperation.FindByQueryWithConsistency<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"returnType must not be null!");
            return new ReactiveFindByQuerySupport<R>(this.template, this.domainType, returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.fields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithProjection<T> project(String[] fields) {
            Assert.notNull((Object)fields, (String)"Fields must not be null");
            Assert.isNull((Object)this.distinctFields, (String)"only one of project(fields) and distinct(distinctFields) can be specified");
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, this.distinctFields, fields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithDistinct<T> distinct(String[] distinctFields) {
            Assert.notNull((Object)distinctFields, (String)"distinctFields must not be null");
            Assert.isNull((Object)this.fields, (String)"only one of project(fields) and distinct(distinctFields) can be specified");
            String[] dFields = distinctFields.length == 1 && "-".equals(distinctFields[0]) ? null : distinctFields;
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, dFields, this.fields, this.support);
        }

        @Override
        public Mono<T> one() {
            return this.all().singleOrEmpty();
        }

        @Override
        public Mono<T> first() {
            return this.all().next();
        }

        @Override
        public Flux<T> all() {
            PseudoArgs<QueryOptions> pArgs = new PseudoArgs<QueryOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            String statement = this.assembleEntityQuery(false, this.distinctFields, pArgs.getScope(), pArgs.getCollection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("findByQuery {} statement: {}", pArgs, (Object)statement);
            }
            CouchbaseClientFactory clientFactory = this.template.getCouchbaseClientFactory();
            ReactiveScope rs = clientFactory.withScope(pArgs.getScope()).getScope().reactive();
            Mono allResult = TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMap(s -> {
                if (!s.isPresent()) {
                    QueryOptions opts = this.buildOptions((QueryOptions)pArgs.getOptions());
                    return pArgs.getScope() == null ? clientFactory.getCluster().reactive().query(statement, opts) : rs.query(statement, opts);
                }
                TransactionQueryOptions opts = this.buildTransactionOptions((QueryOptions)pArgs.getOptions());
                JsonSerializer jSer = clientFactory.getCluster().environment().jsonSerializer();
                return AttemptContextReactiveAccessor.createReactiveTransactionAttemptContext(((CouchbaseResourceHolder)((Object)((Object)s.get()))).getCore(), jSer).query(OptionsBuilder.queryContext(pArgs.getScope(), pArgs.getCollection(), rs.bucketName()) == null ? null : rs, statement, opts);
            });
            return allResult.onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            }).flatMapMany(o -> o instanceof ReactiveQueryResult ? ((ReactiveQueryResult)o).rowsAsObject() : Flux.fromIterable((Iterable)((TransactionQueryResult)o).rowsAsObject())).flatMap(row -> {
                String id = "";
                Long cas = 0L;
                if (!this.query.isDistinct() && this.distinctFields == null) {
                    id = row.getString("__id");
                    if (id == null) {
                        id = row.getString("_ID");
                        row.removeKey("_ID");
                    }
                    if ((cas = row.getLong("__cas")) == null) {
                        cas = row.getLong("_CAS");
                        row.removeKey("_CAS");
                    }
                    row.removeKey("__id");
                    row.removeKey("__cas");
                }
                return this.support.decodeEntity(id, row.toString(), cas, this.returnType, pArgs.getScope(), pArgs.getCollection(), null, null);
            });
        }

        public QueryOptions buildOptions(QueryOptions options) {
            QueryScanConsistency qsc = this.scanConsistency != null ? this.scanConsistency : this.template.getConsistency();
            return this.query.buildQueryOptions(options, qsc);
        }

        private TransactionQueryOptions buildTransactionOptions(QueryOptions options) {
            TransactionQueryOptions opts = OptionsBuilder.buildTransactionQueryOptions(this.buildOptions(options));
            return opts;
        }

        @Override
        public Mono<Long> count() {
            PseudoArgs<QueryOptions> pArgs = new PseudoArgs<QueryOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            String statement = this.assembleEntityQuery(true, this.distinctFields, pArgs.getScope(), pArgs.getCollection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("findByQuery {} statement: {}", pArgs, (Object)statement);
            }
            CouchbaseClientFactory clientFactory = this.template.getCouchbaseClientFactory();
            ReactiveScope rs = clientFactory.withScope(pArgs.getScope()).getScope().reactive();
            Mono allResult = TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMap(s -> {
                if (!s.isPresent()) {
                    QueryOptions opts = this.buildOptions((QueryOptions)pArgs.getOptions());
                    return pArgs.getScope() == null ? clientFactory.getCluster().reactive().query(statement, opts) : rs.query(statement, opts);
                }
                TransactionQueryOptions opts = this.buildTransactionOptions((QueryOptions)pArgs.getOptions());
                return AttemptContextReactiveAccessor.createReactiveTransactionAttemptContext(((CouchbaseResourceHolder)((Object)((Object)s.get()))).getCore(), clientFactory.getCluster().environment().jsonSerializer()).query(statement, opts);
            });
            return allResult.onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            }).flatMapMany(o -> o instanceof ReactiveQueryResult ? ((ReactiveQueryResult)o).rowsAsObject() : Flux.fromIterable((Iterable)((TransactionQueryResult)o).rowsAsObject())).map(row -> row.getLong((String)row.getNames().iterator().next())).next();
        }

        @Override
        public Mono<Boolean> exists() {
            return this.count().map(count -> count > 0L);
        }

        private String assembleEntityQuery(boolean count, String[] distinctFields, String scope, String collection) {
            return this.query.toN1qlSelectString(this.template.getConverter(), this.template.getBucketName(), scope, collection, this.domainType, this.returnType, count, this.query.getDistinctFields() != null ? this.query.getDistinctFields() : distinctFields, this.fields);
        }
    }
}

