/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.java.kv.MutationResult;
import java.util.Objects;
import java.util.Optional;

public class RemoveResult {
    private final String id;
    private final long cas;
    private final Optional<MutationToken> mutationToken;

    public RemoveResult(String id, long cas, Optional<MutationToken> mutationToken) {
        this.id = id;
        this.cas = cas;
        this.mutationToken = mutationToken;
    }

    public static RemoveResult from(String id, MutationResult result) {
        return new RemoveResult(id, result.cas(), result.mutationToken());
    }

    public String getId() {
        return this.id;
    }

    public long getCas() {
        return this.cas;
    }

    public Optional<MutationToken> getMutationToken() {
        return this.mutationToken;
    }

    public String toString() {
        return "RemoveResult{id='" + this.id + "', cas=" + this.cas + ", mutationToken=" + this.mutationToken + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveResult that = (RemoveResult)o;
        return this.cas == that.cas && Objects.equals(this.id, that.id) && Objects.equals(this.mutationToken, that.mutationToken);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.cas, this.mutationToken);
    }
}

