/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.repository.support.ViewMetadataProvider;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

public enum ViewPostProcessor implements RepositoryProxyPostProcessor
{
    INSTANCE;

    private static final ThreadLocal<Map<Object, Object>> VIEW_METADATA;

    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)ExposeInvocationInterceptor.INSTANCE);
        factory.addAdvice((Advice)ViewInterceptor.INSTANCE);
    }

    public ViewMetadataProvider getViewMetadataProvider() {
        return ThreadBoundViewMetadata.INSTANCE;
    }

    static {
        VIEW_METADATA = new NamedThreadLocal("View Metadata");
    }

    static enum ViewInterceptor implements MethodInterceptor
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            View view = (View)AnnotationUtils.getAnnotation((Method)invocation.getMethod(), View.class);
            if (view != null) {
                Map<Object, Object> map = VIEW_METADATA.get();
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    VIEW_METADATA.set(map);
                }
                map.put(invocation.getMethod(), view);
            }
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                VIEW_METADATA.remove();
            }
        }
    }

    private static enum ThreadBoundViewMetadata implements ViewMetadataProvider
    {
        INSTANCE;


        @Override
        public View getView() {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            Map<Object, Object> map = VIEW_METADATA.get();
            return map == null ? null : (View)map.get(invocation.getMethod());
        }
    }
}

