/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.transaction;

import org.springframework.data.couchbase.transaction.CouchbaseCallbackTransactionManager;
import org.springframework.data.couchbase.transaction.CouchbaseTransactionDefinition;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.reactive.TransactionCallback;
import org.springframework.transaction.reactive.TransactionalOperator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CouchbaseTransactionalOperator
implements TransactionalOperator {
    private final CouchbaseCallbackTransactionManager manager;

    CouchbaseTransactionalOperator(CouchbaseCallbackTransactionManager manager) {
        this.manager = manager;
    }

    public static CouchbaseTransactionalOperator create(CouchbaseCallbackTransactionManager manager) {
        return new CouchbaseTransactionalOperator(manager);
    }

    public <T> Mono<T> transactional(Mono<T> mono) {
        return this.transactional(Flux.from(mono)).singleOrEmpty();
    }

    public <T> Flux<T> execute(TransactionCallback<T> action) throws TransactionException {
        return Flux.defer(() -> {
            CouchbaseTransactionDefinition def = new CouchbaseTransactionDefinition();
            return this.manager.executeReactive((TransactionDefinition)def, action);
        });
    }
}

