/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@ReadingConverter
public class IntegerToEnumConverterFactory
implements ConverterFactory<Integer, Enum> {
    private final ObjectMapper objectMapper;

    public IntegerToEnumConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends Enum> Converter<Integer, T> getConverter(Class<T> targetType) {
        return new ObjectToEnum(IntegerToEnumConverterFactory.getEnumType(targetType), this.objectMapper);
    }

    public static Class<?> getEnumType(Class<?> targetType) {
        Class<?> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, () -> "The target type " + targetType.getName() + " does not refer to an enum");
        return enumType;
    }

    private static class ObjectToEnum<T extends Enum>
    implements Converter<Integer, T> {
        private final Class<T> enumType;
        private final ObjectMapper objectMapper;

        ObjectToEnum(Class<T> enumType, ObjectMapper objectMapper) {
            this.enumType = enumType;
            this.objectMapper = objectMapper;
        }

        @Nullable
        public T convert(Integer source) {
            if (source == null) {
                return null;
            }
            try {
                return (T)((Enum)this.objectMapper.readValue(source.toString(), this.enumType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

