/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.transport.TransportAddress;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ClusterNodes
implements Streamable<TransportAddress> {
    public static ClusterNodes DEFAULT = ClusterNodes.of("127.0.0.1:9300");
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private final List<TransportAddress> clusterNodes;

    private ClusterNodes(String source) {
        Assert.hasText((String)source, (String)"Cluster nodes source must not be null or empty!");
        String[] nodes = StringUtils.delimitedListToStringArray((String)source, (String)COMMA);
        this.clusterNodes = Arrays.stream(nodes).map(node -> {
            String[] segments = StringUtils.delimitedListToStringArray((String)node, (String)COLON);
            Assert.isTrue((segments.length == 2 ? 1 : 0) != 0, () -> String.format("Invalid cluster node %s in %s! Must be in the format host:port!", node, source));
            String host = segments[0].trim();
            String port = segments[1].trim();
            Assert.hasText((String)host, () -> String.format("No host name given cluster node %s!", node));
            Assert.hasText((String)port, () -> String.format("No port given in cluster node %s!", node));
            return new TransportAddress(ClusterNodes.toInetAddress(host), Integer.valueOf(port).intValue());
        }).collect(Collectors.toList());
    }

    public static ClusterNodes of(String source) {
        return new ClusterNodes(source);
    }

    public Iterator<TransportAddress> iterator() {
        return this.clusterNodes.iterator();
    }

    private static InetAddress toInetAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException o_O) {
            throw new IllegalArgumentException(o_O);
        }
    }
}

