/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.query.QueryService;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.ContinuousQueryListenerContainerConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableContinuousQueries;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.listener.ContinuousQueryDefinition;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.data.gemfire.listener.annotation.ContinuousQuery;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;

@Configuration
public class ContinuousQueryConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final String ORG_SPRINGFRAMEWORK_DATA_GEMFIRE_PACKAGE_NAME = "org.springframework.data.gemfire";
    protected static final String ORG_SPRINGFRAMEWORK_PACKAGE_NAME = "org.springframework";
    private int phase;
    @Autowired(required=false)
    private List<ContinuousQueryListenerContainerConfigurer> configurers = Collections.emptyList();
    private String errorHandlerBeanName;
    private String poolName;
    private String queryServiceBeanName;
    private String taskExecutorBeanName;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableContinuousQueries.class;
    }

    public void setImportMetadata(AnnotationMetadata importingClassMetadata) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableContinuousQueriesAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.setErrorHandlerBeanName(enableContinuousQueriesAttributes.getString("errorHandlerBeanName"));
            this.setPhase((Integer)enableContinuousQueriesAttributes.getNumber("phase"));
            this.setPoolName(enableContinuousQueriesAttributes.getString("poolName"));
            this.setQueryServiceBeanName(enableContinuousQueriesAttributes.getString("queryServiceBeanName"));
            this.setTaskExecutorBeanName(enableContinuousQueriesAttributes.getString("taskExecutorBeanName"));
        }
    }

    @Bean
    public BeanPostProcessor continuousQueryBeanPostProcessor() {
        return new BeanPostProcessor(){
            private ContinuousQueryListenerContainer container;
            private List<ContinuousQueryDefinition> continuousQueryDefinitions = new ArrayList<ContinuousQueryDefinition>();

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ContinuousQueryListenerContainer) {
                    this.container = (ContinuousQueryListenerContainer)bean;
                    this.continuousQueryDefinitions.forEach(this.container::addListener);
                    this.continuousQueryDefinitions.clear();
                } else if (ContinuousQueryConfiguration.this.isApplicationBean(bean, beanName)) {
                    Object resolvedBean = ContinuousQueryConfiguration.this.resolveTargetObject(bean);
                    List definitions = Arrays.stream(resolvedBean.getClass().getMethods()).filter(method -> method.isAnnotationPresent(ContinuousQuery.class)).map(method -> ContinuousQueryDefinition.from(resolvedBean, method)).collect(Collectors.toList());
                    Optional.ofNullable(this.container).map(container -> {
                        definitions.forEach(container::addListener);
                        return container;
                    }).orElseGet(() -> {
                        this.continuousQueryDefinitions.addAll(definitions);
                        return null;
                    });
                }
                return bean;
            }
        };
    }

    private boolean isApplicationBean(Object bean, String beanName) {
        return Optional.ofNullable(bean).map(this::resolveTargetObject).map(Object::getClass).map(Class::getPackage).map(Package::getName).filter(StringUtils::hasText).filter(packageName -> packageName.startsWith(ORG_SPRINGFRAMEWORK_DATA_GEMFIRE_PACKAGE_NAME) || !packageName.startsWith(ORG_SPRINGFRAMEWORK_PACKAGE_NAME)).isPresent();
    }

    private boolean isNotProxy(Object bean) {
        return !this.isProxy(bean);
    }

    private boolean isProxy(Object bean) {
        return AopUtils.isAopProxy((Object)bean);
    }

    private Object resolveTargetObject(Object bean) {
        return Optional.ofNullable(bean).filter(this::isProxy).map(proxy -> AopProxyUtils.getSingletonTarget((Object)proxy)).orElse(bean);
    }

    @Bean
    public ContinuousQueryListenerContainer continuousQueryListenerContainer(GemFireCache gemfireCache) {
        Assert.state((boolean)CacheUtils.isClient(gemfireCache), (String)"Continuous Queries (CQ) may only be used in a ClientCache application");
        ContinuousQueryListenerContainer container = new ContinuousQueryListenerContainer();
        container.setCache((RegionService)gemfireCache);
        container.setContinuousQueryListenerContainerConfigurers(this.resolveContinuousQueryListenerContainerConfigurers());
        this.resolveErrorHandler().ifPresent(container::setErrorHandler);
        this.resolvePhase().ifPresent(container::setPhase);
        this.resolvePoolName().ifPresent(container::setPoolName);
        this.resolveQueryService().ifPresent(container::setQueryService);
        this.resolveTaskExecutor().ifPresent(container::setTaskExecutor);
        return container;
    }

    protected List<ContinuousQueryListenerContainerConfigurer> resolveContinuousQueryListenerContainerConfigurers() {
        return Optional.ofNullable(this.configurers).filter(configurers -> !configurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(ContinuousQueryListenerContainerConfigurer.class, true, false);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    protected Optional<ErrorHandler> resolveErrorHandler() {
        return Optional.ofNullable(this.getErrorHandlerBeanName()).filter(StringUtils::hasText).map(errorHandlerBeanName -> (ErrorHandler)this.getBeanFactory().getBean(errorHandlerBeanName, ErrorHandler.class));
    }

    protected Optional<Integer> resolvePhase() {
        return Optional.of(this.getPhase()).filter(phase -> phase != 0);
    }

    protected Optional<String> resolvePoolName() {
        return Optional.ofNullable(this.getPoolName()).filter(StringUtils::hasText);
    }

    protected Optional<QueryService> resolveQueryService() {
        return Optional.ofNullable(this.getQueryServiceBeanName()).filter(StringUtils::hasText).map(queryServiceBeanName -> (QueryService)this.getBeanFactory().getBean(queryServiceBeanName, QueryService.class));
    }

    protected Optional<Executor> resolveTaskExecutor() {
        return Optional.ofNullable(this.getTaskExecutorBeanName()).filter(StringUtils::hasText).map(taskExecutorBeanName -> (Executor)this.getBeanFactory().getBean(taskExecutorBeanName, Executor.class));
    }

    public void setErrorHandlerBeanName(String errorHandlerBeanName) {
        this.errorHandlerBeanName = errorHandlerBeanName;
    }

    protected String getErrorHandlerBeanName() {
        return this.errorHandlerBeanName;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    protected int getPhase() {
        return this.phase;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected String getPoolName() {
        return this.poolName;
    }

    public void setQueryServiceBeanName(String queryServiceBeanName) {
        this.queryServiceBeanName = queryServiceBeanName;
    }

    protected String getQueryServiceBeanName() {
        return this.queryServiceBeanName;
    }

    public void setTaskExecutorBeanName(String taskExecutorBeanName) {
        this.taskExecutorBeanName = taskExecutorBeanName;
    }

    protected String getTaskExecutorBeanName() {
        return this.taskExecutorBeanName;
    }
}

