/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.server.CacheServer;
import org.junit.AfterClass;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.gemfire.tests.integration.IntegrationTestsSupport;
import org.springframework.data.gemfire.tests.process.ProcessExecutor;
import org.springframework.data.gemfire.tests.process.ProcessWrapper;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.data.gemfire.tests.util.SocketUtils;
import org.springframework.data.gemfire.util.ArrayUtils;

public abstract class ClientServerIntegrationTestsSupport
extends IntegrationTestsSupport {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String GEMFIRE_CACHE_SERVER_PORT_PROPERTY = "spring.data.gemfire.cache.server.port";
    public static final String GEMFIRE_LOCALHOST_PORT = "localhost[%d]";
    public static final String GEMFIRE_POOL_SERVERS_PROPERTY = "spring.data.gemfire.pool.servers";
    protected static final String DEBUG_ENDPOINT = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005";
    protected static final String DEBUGGING_ENABLED_PROPERTY = "spring.data.gemfire.test.debugging.enabled";
    protected static final String PROCESS_RUN_MANUAL_PROPERTY = "spring.data.gemfire.test.process.run-manual";
    private static final Set<Integer> allocatedPorts = new ConcurrentSkipListSet<Integer>();

    @AfterClass
    public static void deallocatePorts() {
        allocatedPorts.clear();
    }

    protected static int findAvailablePort() throws IOException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(0));
            int n = serverSocket.getLocalPort();
            return n;
        }
        finally {
            SocketUtils.close(serverSocket);
        }
    }

    protected static int findAndReserveAvailablePort() throws IOException {
        int availablePort = 0;
        while (!allocatedPorts.add(availablePort = ClientServerIntegrationTestsSupport.findAvailablePort())) {
        }
        return availablePort;
    }

    protected static int intValue(Number number) {
        return number != null ? number.intValue() : 0;
    }

    protected static boolean isProcessRunAuto() {
        return !ClientServerIntegrationTestsSupport.isProcessRunManual();
    }

    protected static boolean isProcessRunManual() {
        return Boolean.getBoolean(PROCESS_RUN_MANUAL_PROPERTY);
    }

    protected static ProcessWrapper run(Class<?> type, String ... arguments) throws IOException {
        return ClientServerIntegrationTestsSupport.run(ClientServerIntegrationTestsSupport.createDirectory(ClientServerIntegrationTestsSupport.asDirectoryName(type)), type, arguments);
    }

    protected static ProcessWrapper run(File workingDirectory, Class<?> type, String ... arguments) throws IOException {
        return ClientServerIntegrationTestsSupport.isProcessRunAuto() ? ProcessExecutor.launch(ClientServerIntegrationTestsSupport.createDirectory(workingDirectory), type, arguments) : null;
    }

    protected static ProcessWrapper run(String classpath, Class<?> type, String ... arguments) throws IOException {
        return ClientServerIntegrationTestsSupport.run(ClientServerIntegrationTestsSupport.createDirectory(ClientServerIntegrationTestsSupport.asDirectoryName(type)), classpath, type, arguments);
    }

    protected static ProcessWrapper run(File workingDirectory, String classpath, Class<?> type, String ... arguments) throws IOException {
        return ClientServerIntegrationTestsSupport.isProcessRunAuto() ? ProcessExecutor.launch(ClientServerIntegrationTestsSupport.createDirectory(workingDirectory), classpath, type, arguments) : null;
    }

    protected static AnnotationConfigApplicationContext runSpringApplication(Class<?> annotatedClass, String ... args) {
        return ClientServerIntegrationTestsSupport.runSpringApplication((Class[])ArrayUtils.asArray((Object[])new Class[]{annotatedClass}), args);
    }

    protected static AnnotationConfigApplicationContext runSpringApplication(Class<?>[] annotatedClasses, String ... args) {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext((Class[])annotatedClasses);
        applicationContext.registerShutdownHook();
        return applicationContext;
    }

    protected static boolean stop(ProcessWrapper process) {
        return ClientServerIntegrationTestsSupport.stop(process, DEFAULT_WAIT_DURATION);
    }

    protected static boolean stop(ProcessWrapper process, long duration) {
        return Optional.ofNullable(process).map(it -> {
            it.stop(duration);
            if (it.isNotRunning() && ClientServerIntegrationTestsSupport.isDeleteDirectoryOnExit()) {
                FileSystemUtils.deleteRecursive(it.getWorkingDirectory());
            }
            return it.isRunning();
        }).orElse(true);
    }

    protected static boolean waitForCacheServerToStart(CacheServer cacheServer) {
        return ClientServerIntegrationTestsSupport.waitForServerToStart(cacheServer.getBindAddress(), cacheServer.getPort(), DEFAULT_WAIT_DURATION);
    }

    protected static boolean waitForCacheServerToStart(CacheServer cacheServer, long duration) {
        return ClientServerIntegrationTestsSupport.waitForServerToStart(cacheServer.getBindAddress(), cacheServer.getPort(), duration);
    }

    protected static boolean waitForServerToStart(String host, int port) {
        return ClientServerIntegrationTestsSupport.waitForServerToStart(host, port, DEFAULT_WAIT_DURATION);
    }

    protected static boolean waitForServerToStart(String host, int port, long duration) {
        AtomicBoolean connected = new AtomicBoolean(false);
        return ClientServerIntegrationTestsSupport.waitOn(() -> {
            Socket socket = null;
            try {
                if (!connected.get()) {
                    socket = new Socket(host, port);
                    connected.set(true);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                SocketUtils.close(socket);
            }
            return connected.get();
        }, duration);
    }

    protected static int waitForProcessToStop(Process process, File directory) {
        return ClientServerIntegrationTestsSupport.waitForProcessToStop(process, directory, DEFAULT_WAIT_DURATION);
    }

    protected static int waitForProcessToStop(Process process, File directory, long duration) {
        long timeout = System.currentTimeMillis() + duration;
        try {
            while (process.isAlive() && System.currentTimeMillis() < timeout) {
                if (!process.waitFor(500L, TimeUnit.MILLISECONDS)) continue;
                return process.exitValue();
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        return process.isAlive() ? -1 : process.exitValue();
    }
}

