/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.util.Optional;
import org.junit.After;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.gemfire.tests.integration.IntegrationTestsSupport;

public abstract class SpringApplicationContextIntegrationTestsSupport
extends IntegrationTestsSupport {
    private volatile ConfigurableApplicationContext applicationContext;

    @After
    public void closeApplicationContext() {
        Optional.ofNullable(this.applicationContext).ifPresent(ConfigurableApplicationContext::close);
    }

    protected ConfigurableApplicationContext newApplicationContext(Class<?> ... annotatedClasses) {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.register((Class[])annotatedClasses);
        applicationContext.registerShutdownHook();
        this.processBeforeRefresh((ConfigurableApplicationContext)applicationContext);
        applicationContext.refresh();
        return this.setApplicationContext(applicationContext);
    }

    protected ConfigurableApplicationContext processBeforeRefresh(ConfigurableApplicationContext applicationContext) {
        return applicationContext;
    }

    protected <T extends ConfigurableApplicationContext> T setApplicationContext(T applicationContext) {
        this.applicationContext = applicationContext;
        return applicationContext;
    }

    protected <T extends ConfigurableApplicationContext> T getApplicationContext() {
        return (T)this.applicationContext;
    }

    protected <T> T getBean(Class<T> requiredType) {
        return (T)this.getApplicationContext().getBean(requiredType);
    }

    protected <T> T getBean(String beanName, Class<T> requiredType) {
        return (T)this.getApplicationContext().getBean(beanName, requiredType);
    }
}

