/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration.config;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.config.annotation.CacheServerConfigurer;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableLocator;
import org.springframework.data.gemfire.config.annotation.EnableLogging;
import org.springframework.data.gemfire.config.annotation.EnableManager;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.util.ClassUtils;

@Configuration
public class ClientServerIntegrationTestsConfiguration {
    private static final int DEFAULT_PORT = 40404;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Logger getLogger() {
        return this.logger;
    }

    @Bean
    @Conditional(value={SpringBootIsAbsentCondition.class})
    static PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    CacheServerConfigurer cacheServerPortConfigurer(@Value(value="${spring.data.gemfire.cache.server.port:40404}") int port) {
        return (beanName, cacheServerFactoryBean) -> cacheServerFactoryBean.setPort(port);
    }

    @Bean
    ClientCacheConfigurer clientCachePoolPortConfigurer(@Value(value="${spring.data.gemfire.cache.server.port:40404}") int port) {
        return (beanName, clientCacheFactoryBean) -> {
            List<ConnectionEndpoint> servers = Collections.singletonList(new ConnectionEndpoint("localhost", port));
            clientCacheFactoryBean.setServers(servers);
        };
    }

    public static class SpringBootIsAbsentCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !ClassUtils.isPresent((String)"org.springframework.boot.SpringApplication", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    @Configuration
    @EnableLocator
    @EnableLogging
    @EnableManager(start=true)
    @Profile(value={"locator-manager"})
    static class LocatorManagerConfiguration {
        LocatorManagerConfiguration() {
        }
    }
}

